% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compareCompositionPlot.R
\name{compareCompositionPlot}
\alias{compareCompositionPlot}
\title{Compare the compositions of a data set and a subset}
\usage{
compareCompositionPlot(
  df,
  idx,
  column,
  showPercentages = TRUE,
  fontSizePercentages = 4
)
}
\arguments{
\item{df}{A \code{data.frame}-like object (such that \code{df[[column]]}
works).}

\item{idx}{A numeric vector representing the row indexes of \code{df}
corresponding to the subset of interest. Can also be a named list
of index vectors if multiple subsets are of interest.}

\item{column}{A character scalar corresponding to a column of
\code{df} and representing the variable for which the composition
should be calculated.}

\item{showPercentages}{Logical scalar, indicating whether relative
frequencies of each category should be shown in the plot.}

\item{fontSizePercentages}{Numerical scalar, indicating the font size
of the relative frequencies, if \code{showPercentages} is \code{TRUE}.}
}
\value{
A \code{ggplot} object.
}
\description{
Plot the composition of a data set (e.g., the number of cells from
each cell type) and contrast it with the corresponding composition
of a subset.
}
\examples{
df <- data.frame(celltype = sample(LETTERS[1:5], 1000, replace = TRUE,
                                   prob = c(0.1, 0.2, 0.5, 0.05, 0.15)))
idx <- sample(seq_len(1000), 200)
compareCompositionPlot(df, idx, "celltype")

}
\author{
Charlotte Soneson
}
