% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scsampler.R
\name{scsampler}
\alias{scsampler}
\title{Run scSampler to subsample a matrix}
\usage{
scsampler(mat, N, random_split = 1, seed = 0)
}
\arguments{
\item{mat}{m x n matrix. Samples (the dimension along which to subsample)
should be in the rows, features in the columns.}

\item{N}{Numeric scalar, the number of samples to retain.}

\item{random_split}{Numeric scalar, the number of parts to randomly
split the data into before subsampling within each part. A larger
value will speed up computations, but give less optimal results.}

\item{seed}{Numeric scalar, passed to \code{scsampler} to seed the random
number generator.}
}
\value{
A numeric vector with indices to retain.
}
\description{
Perform subsampling with the \code{scSampler} python package.
}
\details{
The first time this function is run, it will create a conda environment
containing the \code{scSampler} package.
This is done via the \code{basilisk} R/Bioconductor package - see the
documentation for that package for troubleshooting.
}
\examples{
if (!(Sys.info()["sysname"] == "Darwin" && Sys.info()["machine"] == "arm64")) {
    x <- matrix(rnorm(500), nrow = 100)
    scsampler(mat = x, N = 10)
}

}
\references{
Song et al (2022): scSampler: fast diversity-preserving subsampling of
large-scale single-cell transcriptomic data.
bioRxiv doi:10.1101/2022.01.15.476407
}
\author{
Charlotte Soneson, Michael Stadler
}
