% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plotTerms}
\alias{plotTerms}
\title{Plot relevance for all terms}
\usage{
plotTerms(object, terms = NULL, order_terms = TRUE, mad_filter = 0.2,
  annotated = TRUE, unannotated_dense = TRUE, unannotated_sparse = FALSE)
}
\arguments{
\item{object}{an object of class \code{Rcpp_SlalomModel}}

\item{terms}{integer or character vector, providing either indices for
desired terms (if an integer) or the term names (if character); default is
\code{NULL}, in which case all terms are plotted.}

\item{order_terms}{logical(1), should factors be ordered by relevance (
\code{TRUE}, default), or in the order the come}

\item{mad_filter}{numeric(1), filter factors by this mean absolute deviation
to exclude outliers. For large datasets this can be set close to 0; default
is \code{0.2}.}

\item{annotated}{logical(1), should annotated factors be plotted? Default is
\code{TRUE}}

\item{unannotated_dense}{logical(1), should dense unannotated factors be
plotted? Default is \code{TRUE}}

\item{unannotated_sparse}{logical(1), should sparse unannotated factors be
plotted? Default is \code{TRUE}}
}
\value{
a ggplot plot object
}
\description{
Plot relevance for all terms
}
\examples{
gmtfile <- system.file("extdata", "reactome_subset.gmt", package = "slalom")
genesets <- GSEABase::getGmt(gmtfile)
data("mesc")
model <- newSlalomModel(mesc, genesets, n_hidden = 5, min_genes = 10)
model <- initSlalom(model)
model <- trainSlalom(model, nIterations = 10)
plotTerms(model)
}
