% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/AllHelperFunctions.R
\docType{methods}
\name{newSlingshotDataSet}
\alias{newSlingshotDataSet}
\alias{newSlingshotDataSet,data.frame,ANY-method}
\alias{newSlingshotDataSet,matrix,numeric-method}
\alias{newSlingshotDataSet,matrix,factor-method}
\alias{newSlingshotDataSet,matrix,ANY-method}
\alias{newSlingshotDataSet,matrix,character-method}
\alias{newSlingshotDataSet,matrix,matrix-method}
\title{Initialize an object of class \code{SlingshotDataSet}}
\usage{
newSlingshotDataSet(reducedDim, clusterLabels, ...)

\S4method{newSlingshotDataSet}{data.frame,ANY}(reducedDim, clusterLabels, ...)

\S4method{newSlingshotDataSet}{matrix,numeric}(reducedDim, clusterLabels, ...)

\S4method{newSlingshotDataSet}{matrix,factor}(reducedDim, clusterLabels, ...)

\S4method{newSlingshotDataSet}{matrix,ANY}(reducedDim, clusterLabels, ...)

\S4method{newSlingshotDataSet}{matrix,character}(reducedDim, clusterLabels, ...)

\S4method{newSlingshotDataSet}{matrix,matrix}(
  reducedDim,
  clusterLabels,
  lineages = list(),
  adjacency = matrix(NA, 0, 0),
  curves = list(),
  slingParams = list()
)
}
\arguments{
\item{reducedDim}{matrix. An \code{n} by \code{p} numeric matrix or data
frame giving the coordinates of the cells in a reduced dimensionality
space.}

\item{clusterLabels}{character. A character vector of length \code{n}
denoting each cell's cluster label.}

\item{...}{additional components of a \code{SlingshotDataSet} to specify.
This may include any of the following:}

\item{lineages}{list. A list with each element a character vector of cluster
names representing a lineage as an ordered set of clusters.}

\item{adjacency}{matrix. A binary matrix describing the connectivity
between clusters induced by the minimum spanning tree.}

\item{curves}{list. A list of \code{\link[princurve]{principal_curve}}
objects produced by \code{\link{getCurves}}.}

\item{slingParams}{list. Additional parameters used by Slingshot. These may
specify how the minimum spanning tree on clusters was constructed:
\itemize{
\item{\code{start.clus}}{ character. The label of the root cluster.}
\item{\code{end.clus}}{ character. Vector of cluster labels indicating the
terminal clusters.}
\item{\code{start.given}}{ logical. A logical value
indicating whether the initial state was pre-specified.}
\item{\code{end.given}}{ logical. A vector of logical values indicating
whether each terminal state was pre-specified}
\item{\code{dist}}{ matrix. A
numeric matrix of pairwise cluster distances.} }
They may also specify how simultaneous principal curves were constructed:
\itemize{
\item{\code{shrink}}{ logical or numeric between 0 and 1. Determines
whether and how much to shrink branching lineages toward their shared
average curve.}
\item{\code{extend}}{ character. Specifies the method for handling
root and leaf clusters of lineages when constructing the initial,
piece-wise linear curve. Accepted values are 'y' (default), 'n', and 'pc1'.
See \code{\link{getCurves}} for details.}
\item{\code{reweight}}{ logical.
Indicates whether to allow cells shared
between lineages to be reweighted during curve-fitting. If \code{TRUE},
cells shared between lineages will be iteratively reweighted based on the
quantiles of their projection distances to each curve.}
\item{\code{reassign}}{ logical.
Indicates whether to reassign cells to
lineages at each iteration. If \code{TRUE}, cells will be added to a
lineage when their projection distance to the curve is less than the median
distance for all cells currently assigned to the lineage. Additionally,
shared cells will be removed from a lineage if their projection distance to
the curve is above the 90th percentile and their weight along the curve is
less than \code{0.1}.}
\item{\code{shrink.method}}{ character.
Denotes how to determine the amount of shrinkage for a branching lineage.
Accepted values are the same as for \code{kernel} in  the \code{density}
function (default is \code{"cosine"}), as well as \code{"tricube"} and
\code{"density"}. See \code{\link{getCurves}} for details.}
\item{Other parameters specified by
\code{\link[princurve]{principal_curve}}}. }}
}
\value{
A \code{SlingshotDataSet} object with all specified values.
}
\description{
Constructs a \code{SlingshotDataSet} object. Additional helper
  methods for manipulating \code{SlingshotDataSet} objects are  also
  described below. We now recommend using
  \code{\link[TrajectoryUtils]{PseudotimeOrdering}} objects, instead.
}
\examples{
rd <- matrix(data=rnorm(100), ncol=2)
cl <- sample(letters[seq_len(5)], 50, replace = TRUE)
sds <- newSlingshotDataSet(rd, cl)

}
\seealso{
\code{\link[TrajectoryUtils]{PseudotimeOrdering}}
}
