% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf_idf_iae_wrappers.R
\name{iae}
\alias{iae}
\title{standard inverse average expression}
\usage{
iae(expr, features = NULL, thres = 0)
}
\arguments{
\item{expr}{a matrix, features in row and cells in column}

\item{features}{vector, feature names or indexes to compute}

\item{thres}{numeric, cell only counts when expr > threshold, default 0}
}
\value{
a vector of inverse average expression score for each feature
}
\description{
standard inverse average expression
}
\details{
\deqn{\mathbf{IAE_i} = log(1+\frac{n}{\hat N_{i,j}+1})}
where \eqn{n} is the total number of cells, \eqn{N_{i,j}} is the counts of
feature \eqn{i} in cell \eqn{j}.
}
\examples{
data <- matrix(rpois(100, 2), 10, dimnames = list(1:10))
smartid:::iae(data)
}
