% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/higher_level_functions.R
\name{percent_spliced_in}
\alias{percent_spliced_in}
\title{Relative measure of splice variant usage, limited currently to
cassette exon splice variants}
\usage{
percent_spliced_in(
  inclusion_group1,
  inclusion_group2,
  exclusion_group,
  min_count = 20,
  group_names = NULL
)
}
\arguments{
\item{inclusion_group1, inclusion_group2, exclusion_group}{Where each
is a list of 1 or more QueryBuilder objects}

\item{min_count}{minimum total count (denominator) required to not
be assigned -1}

\item{group_names}{Optional vector of strings representing the
group names}
}
\value{
A DataFrame of samples, with their PSI score and metadata,
which had > 0 coverage in at least one resulting row in at
least one of the groups
}
\description{
Similar to the JIR, this calculates Percent Spliced In (PSI) statistics
for the definition of 2 different groups: inclusion and exclusion.
Currently this function only supports the cassette exon use case.
}
\details{
Inclusion typically defines 2 basic queries, one for the junction
preceding the cassette exon, and the second for the junction following
the cassette exon.  The exclusion group contains one basic query
which defines the junction which skips the cassette exon.

The PSI itself is implemented as:

\code{PSI(inclusion1, inclusion2, exclusion) =
  mean(inclusion1, inclusion2) / (mean(inclusion1, inclusion2) + exclusion)}

where each term denotes the coverage of junctions that resulted
from the basic queries in that group in the current sample.
}
\examples{
in1 <- QueryBuilder(compilation = "srav2", regions = "chr1:94468008-94472172")
in1 <- set_coordinate_modifier(in1, Coordinates$Exact)
in1 <- set_row_filters(in1, strand == "+")

in2 <- QueryBuilder(compilation = "srav2", regions = "chr1:94468008-94472172")
in2 <- set_coordinate_modifier(in2, Coordinates$Exact)
in2 <- set_row_filters(in2, strand == "+")

ex <- QueryBuilder(compilation = "srav2", regions = "chr1:94468008-94475142")
ex <- set_coordinate_modifier(ex, Coordinates$Exact)
ex <- set_row_filters(ex, strand == "+")

percent_spliced_in(list(in1), list(in2), list(ex))
}
