% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cellLevelMetrics.R
\name{minCellTypeStructDist}
\alias{minCellTypeStructDist}
\title{Compute minimum distances from each cell types to structure boundaries per structure}
\usage{
minCellTypeStructDist(
  spe,
  allStructs,
  structID = "structID",
  cellTypeColumn,
  imageCol,
  nCores = 1
)
}
\arguments{
\item{spe}{SpatialExperiment object}

\item{allStructs}{sf object; contains spatial structures with corresponding image names}

\item{structID}{character; name of the column in \code{allStructs} containing structure IDs (default: "structID")}

\item{cellTypeColumn}{character; name of the \code{colData} column specifying cell types}

\item{imageCol}{character; name of the \code{colData} column specifying the image name}

\item{nCores}{integer; Number of cores for parallel processing (default = 1)}
}
\value{
A data frame where rows are structure IDs and cols are cell types with minimum distances
}
\description{
Compute minimum distances from each cell types to structure boundaries per structure
}
\examples{
data("sostaSPE")
allStructs <- reconstructShapeDensitySPE(sostaSPE,
    marks = "cellType", imageCol = "imageName",
    markSelect = "A", bndw = 3.5, thres = 0.045
)
minCellTypeStructDist(sostaSPE, allStructs, cellTypeColumn = "cellType", imageCol = "imageName")
}
