% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Reference.R
\name{createReference}
\alias{createReference}
\title{\code{\linkS4class{Reference}} object constructor}
\usage{
createReference(
  counts,
  cell_types,
  nUMI = NULL,
  require_int = TRUE,
  n_max_cells = 10000,
  min_UMI = 100
)
}
\arguments{
\item{counts}{matrix (or dgCMatrix) of gene expression counts from RNA-seq
data, with genes as rows and cells as columns (named by cell barcode)}

\item{cell_types}{factor vector containing cell type annotations for each
cell in the reference (identified by barcode). The factor levels represent
the possible cell types.}

\item{nUMI}{optional, numeric vector of total UMI counts per cell (identified
by barcode). If not provided, nUMI will be calculated as the column sums of
the counts matrix.}

\item{require_int}{logical, whether counts and nUMI are required to be
integers (default: \code{TRUE})}

\item{n_max_cells}{numeric, maximum number of cells per cell type. Will
downsample if this number is exceeded. (default: 10,000)}

\item{min_UMI}{numeric, minimum UMI count for cells to be included in the
reference (default: 100)}
}
\value{
\code{\linkS4class{Reference}} object
}
\description{
\code{\linkS4class{Reference}} object constructor
}
\examples{
data(rctdSim)

cell_types <- rctdSim$reference_cell_types[["cell_type"]]
names(cell_types) <- rownames(rctdSim$reference_cell_types)
reference <- createReference(rctdSim$reference_counts, cell_types)

}
\keyword{internal}
