% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/GeneSetDb-methods.R
\name{featureIdMap}
\alias{featureIdMap}
\alias{featureIdMap,GeneSetDb-method}
\title{Fetch the featureIdMap for a \code{GeneSetDb}}
\usage{
featureIdMap(x, ...)

\S4method{featureIdMap}{GeneSetDb}(x, as.dt = FALSE)
}
\arguments{
\item{x}{the object to retrieve the featureIdMap from}

\item{...}{pass through arguments}

\item{as.dt}{If \code{FALSE} (default), the data.frame like thing that
this funciton returns will be set to a data.frame. Set this to \code{TRUE}
to keep this object as a \code{data.table}}
}
\value{
a data.frame of input feature_id's to conformed id's/rows/etc
}
\description{
The GeneSetDb has an internal data structure that is used to cross reference
the feature_id's used in the database construction to the features in the
expression object that is used to run GSEA methods against.
}
\section{Methods (by class)}{
\itemize{
\item \code{featureIdMap(GeneSetDb)}: extract featureIdMap from a GeneSetDb

}}
\examples{
gdb <- exampleGeneSetDb()
vm <- exampleExpressionSet()
gdb <- conform(gdb, vm)
fmap <- featureIdMap(gdb)
}
