% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCellTypeMeanVar.R
\name{plotCellTypeMeanVar}
\alias{plotCellTypeMeanVar}
\title{Plot cell type counts means versus variances}
\usage{
plotCellTypeMeanVar(x)
}
\arguments{
\item{x}{a matrix or table of counts}
}
\value{
a base R plot
}
\description{
This function returns a plot of the log10(mean) versus log10(variance) of 
the cell type counts. The function takes a matrix of cell type counts as 
input. The rows are the clusters/cell types and the columns are the samples.
}
\details{
The expected variance under a binomial distribution is shown in the solid 
line, and the points represent the observed variance for each cell type/row 
in the counts table. The expected variance under different model assumptions
are shown in the different coloured lines.

The mean and variance for each cell type is calculated across all samples.
}
\examples{
library(edgeR)
# Generate some data
# Total number of samples
nsamp <- 10
# True cell type proportions
p <- c(0.05, 0.15, 0.35, 0.45)

# Parameters for beta distribution
a <- 40
b <- a*(1-p)/p

# Sample total cell counts per sample from negative binomial distribution
numcells <- rnbinom(nsamp,size=20,mu=5000)
true.p <- matrix(c(rbeta(nsamp,a,b[1]),rbeta(nsamp,a,b[2]),
          rbeta(nsamp,a,b[3]),rbeta(nsamp,a,b[4])),byrow=TRUE, ncol=nsamp)

counts <- matrix(NA,ncol=nsamp, nrow=nrow(true.p))
rownames(counts) <- paste("c",0:(nrow(true.p)-1), sep="")
for(j in 1:length(p)){
    counts[j,] <- rbinom(nsamp, size=numcells, prob=true.p[j,])
}

plotCellTypeMeanVar(counts)

}
\author{
Belinda Phipson
}
