% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Run_Create_Obj.R
\name{Run_Create_Obj}
\alias{Run_Create_Obj}
\title{This function creates specified spatial transcriptomics data object for further personalized downstream analysis}
\usage{
Run_Create_Obj(gene.matrix, matched.data, obj.type, tech, ss.radius = 3000)
}
\arguments{
\item{gene.matrix}{Gene count matrix. This is usually obtained from 'Run_ST' function.}

\item{matched.data}{Data frame which contains spatial localization matched with gene count matrix. This is usually obtained from 'Run_loc_match' function.}

\item{obj.type}{Type of spatial transcriptomics object being created, can be 'Seurat', 'SpatialExperiment', or 'AnnData'.}

\item{tech}{Type of spatial transcriptomics sequencing technology, can be "Visium", "Slideseq", "Curio-seeker", or "Stereoseq".}

\item{ss.radius}{Optional. Radius for filtering SlideSeq or Curio-seeker spots for Seurat object. Default is 3000.}
}
\value{
Created spatial transcriptomics data object as required by 'obj.type'.
set.seed(123)
gene.count <- matrix(sample(0:100, 200*100, TRUE), nrow=200)
rownames(gene.count) <- paste0('Gene', 1:200)
colnames(gene.count) <- paste0('Spot', 1:100)
matched.data <- data.frame(
  spatial_name = colnames(gene.count),
  barcode_sequence = paste0('BC', 1:100),
  X_coordinate = runif(100,0,10),
  Y_coordinate = runif(100,0,10),
  UMI_count = sample(50:200,100,TRUE)
)
seu <- Run_Create_Obj(
  gene.matrix = gene.count,
  matched.data = matched.data,
  obj.type = 'Seurat',
  tech = 'Slideseq'
)
}
\description{
This function creates specified spatial transcriptomics data object for further personalized downstream analysis
}
\details{
Current mainstream analytic tools for downstream includes: Seurat, SpatialExperiment supported tools, and Squidpy.
This function can help creates corresponding objects for further downstream analysis.
}
