% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allGenerics.R, R/accessors.R
\docType{methods}
\name{getSignificantGenes}
\alias{getSignificantGenes}
\alias{getSignificantGenes}
\alias{getSignificantGenes,stageRTx}
\title{Return significant genes when performing transcript-level analysis.}
\usage{
getSignificantGenes(object, ...)

\S4method{getSignificantGenes}{stageRTx}(object)
}
\arguments{
\item{object}{an object of the \code{\link{stageRClass}} class.}
}
\value{
A matrix with significant genes and their corresponding FDR-adjusted screening stage (aggregated) p-value.
}
\description{
This functions returns a matrix with significant genes by aggregated testing of its respective transcripts.
}
\examples{
#make identifiers linking transcripts to genes
set.seed(1)
genes=paste0("gene",sample(1:200,1000,replace=TRUE))
nGenes=length(table(genes))
transcripts=paste0("tx",1:1000)
tx2gene=data.frame(transcripts,genes)
#gene-wise q-values
pScreen=c(seq(1e-10,1e-2,length.out=nGenes-100),seq(1e-2,.2,length.out=50),seq(50))
names(pScreen)=names(table(genes)) #discards genes that are not simulated
pConfirmation=matrix(runif(1000),nrow=1000,ncol=1)
rownames(pConfirmation)=transcripts
stageRObj <- stageRTx(pScreen=pScreen, pConfirmation=pConfirmation ,pScreenAdjusted=TRUE, tx2gene=tx2gene)
stageRObj <- stageWiseAdjustment(stageRObj, method="dte", alpha=0.05)
head(getSignificantGenes(stageRObj))
}
\references{
Van den Berge K., Soneson C., Robinson M.D., Clement L. (2017). stageR: a general stage-wise method for controlling the gene-level false discovery rate in differential expression and differential transcript usage. Genome Biology 18:151. https://doi.org/10.1186/s13059-017-1277-0
}
