% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDR.R
\docType{methods}
\name{drawPCA}
\alias{drawPCA}
\alias{drawPCA,DGEList-method}
\alias{drawPCA,ExpressionSet-method}
\alias{drawPCA,SummarizedExperiment-method}
\alias{drawPCA,SingleCellExperiment-method}
\alias{drawPCA,SpatialExperiment-method}
\title{Compute and plot the results of a PCA analysis on gene expression data}
\usage{
drawPCA(object, dims = c(1, 2), ...)

\S4method{drawPCA}{ExpressionSet}(object, dims = c(1, 2), precomputed = NULL, textScale = 1, ...)

\S4method{drawPCA}{SummarizedExperiment}(
  object,
  dims = c(1, 2),
  assay = 1,
  precomputed = NULL,
  textScale = 1,
  ...
)

\S4method{drawPCA}{SingleCellExperiment}(
  object,
  dims = c(1, 2),
  assay = 1,
  precomputed = NULL,
  textScale = 1,
  ...
)

\S4method{drawPCA}{SpatialExperiment}(
  object,
  dims = c(1, 2),
  assay = 1,
  precomputed = NULL,
  textScale = 1,
  ...
)
}
\arguments{
\item{object}{a DGEList, SummarizedExperiment or ExpressionSet object
containing gene expression data.}

\item{dims}{a numeric, containing 2 values specifying the dimensions to plot.}

\item{...}{aesthetic mappings to pass to \code{ggplot2::aes_string()}.}

\item{precomputed}{a dimensional reduction results from \code{stats::prcomp}.
result in \code{reducedDims(object)} to plot.}

\item{textScale}{a numeric, specifying the relative scale factor to apply to text on
the plot.}

\item{assay}{a numeric or character, specifying the assay to use (for
\code{SummarizedExperiment} and its derivative classes).}
}
\value{
a ggplot2 object
}
\description{
Compute and plot the results of a PCA analysis on gene expression data
}
\examples{
data("dkd_spe_subset")
drawPCA(dkd_spe_subset)

}
