% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_crop_fast.R
\name{auto_crop_fast}
\alias{auto_crop_fast}
\title{auto_crop_fast}
\usage{
auto_crop_fast(
  img_path,
  max_cell_area = 20000,
  min_cell_area = 7000,
  mean_pix = 0.08,
  annotation = "off",
  blob_factor = 15,
  bg_blob_factor = 10,
  offset = 0.2,
  final_blob_amp = 10,
  test_amount = 0,
  brush_size_blob = 51,
  sigma_blob = 15,
  channel3_string = "DAPI",
  channel2_string = "SYCP3",
  channel1_string = "MLH3",
  file_ext = "jpeg",
  third_channel = "off",
  cell_aspect_ratio = 2,
  strand_amp = 2,
  path_out = img_path,
  resize_l = 720,
  crowded_cells = "FALSE",
  watershed_radius = 50,
  watershed_tol = 0.2,
  cropping_factor = 1.3
)
}
\arguments{
\item{img_path, }{path containing image data to analyse}

\item{max_cell_area, }{Maximum pixel area of a cell candidate}

\item{min_cell_area, }{Minimum pixel area of a cell candidate}

\item{mean_pix, }{Mean pixel intensity of cell crop (in SYCP3 channel)
for normalisation}

\item{annotation, }{Choice to output pipeline choices (recommended to knit)}

\item{blob_factor, }{Contrast factor to multiply original image by before
smoothing/smudging}

\item{bg_blob_factor, }{Contrast factor to multiply original image by to
take background. Used prior to thresholding.}

\item{offset, }{Pixel value offset from bg_blob_factor. Used in thresholding
to make blob mask.}

\item{final_blob_amp, }{Contrast factor to multiply smoothed/smudged image.
Used in thresholding to make blob mask.}

\item{test_amount, }{Optional number of first N images you want to run
function on. For troubleshooting/testing/variable calibration purposes.}

\item{brush_size_blob, }{Brush size for smudging the synaptonemal complex channel to make blobs}

\item{sigma_blob, }{Sigma in Gaussian brush for smudging the synaptonemal complex channel
to make blobs}

\item{channel3_string}{Optional. String appended to the files showing the
channel illuminating cell structures. Defaults to DAPI, if
third channel == "on".}

\item{channel2_string}{String appended to the files showing the channel
illuminating synaptonemal complexes. Defaults to SYCP3}

\item{channel1_string}{String appended to the files showing the channel
illuminating foci. Defaults to MLH3}

\item{file_ext}{file extension of your images e.g. tif jpeg or png.}

\item{third_channel}{Optional, defaults to "off". Set to "on" if you would
also like crops of the third channel.}

\item{cell_aspect_ratio}{Maximum aspect ratio of blob to be defined as a cell}

\item{strand_amp}{multiplication of strand channel for get_blobs function.}

\item{path_out, }{user specified output path. Defaults to img_path}

\item{resize_l}{length for resized image}

\item{crowded_cells}{TRUE or FALSE, defaults to FALSE. Set to TRUE if you
have many cells in a frame that almost touch}

\item{watershed_radius}{Radius (ext variable) in watershed method used
in strand channel. Defaults to 1 (small)}

\item{watershed_tol}{Intensity tolerance for watershed method. Defaults to
0.05.}

\item{cropping_factor}{size of cropping window square, as factor of
characteristic blob radius. Defaults to 1. May need to increase if using
watershed.}
}
\value{
cropped synaptonemal complex and foci channels around single cells, regardless of stage
}
\description{
crop an image around each viable cell candidate.
}
\details{
This function takes all images in a directory, and crops around individual
cells according to the antibody that stains synaptonemal complexes e.g.
SYCP3. First, it increases the brightness and smudges the image with a Gaussian
brush, and creates a mask using thresholding (get_blobs).
Then it deletes cell candidates in the mask deemed too large, too small,
or too long (keep_cells). Using the computeFeatures functions from
EBImage to locate centre and radius, the cropping area is determined and
the original image cropped. These images are saved in either a user specified
directory, or a crops folder at the location of the image files.
}
\examples{
demo_path = paste0(system.file("extdata",package = "synapsis"))
auto_crop_fast(demo_path, annotation = "on", max_cell_area = 30000,
min_cell_area = 7000, file_ext = "tif",crowded_cells = TRUE)
}
\author{
Lucy McNeill
}
