% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auto_crop_fast.R
\name{crop_single_object_fast}
\alias{crop_single_object_fast}
\title{crop_single_object_fast}
\usage{
crop_single_object_fast(
  retained,
  OOI_final,
  counter_final,
  img_orig,
  img_orig_foci,
  img_orig_DAPI = "blank",
  file_sc,
  file_foci,
  file_DAPI = "blank",
  cell_count,
  mean_pix,
  annotation,
  file_base,
  img_path,
  r_max,
  cx,
  cy,
  channel3_string,
  channel2_string,
  channel1_string,
  file_ext,
  third_channel,
  path_out,
  img_orig_highres,
  resize_l,
  crowded_cells,
  cropping_factor
)
}
\arguments{
\item{retained}{Mask of cell candidates which meet size criteria.
After smoothing/smudging and thresholding.}

\item{OOI_final, }{Objects of interest count. Total number of cell
candidates in retained.}

\item{counter_final, }{Counter for single cell we are focussing on. Remove
all other cells where counter_single not equal to counter_final.}

\item{img_orig, }{description}

\item{img_orig_foci, }{description}

\item{img_orig_DAPI, }{description}

\item{file_sc, }{filename of synaptonemal complex channel image}

\item{file_foci, }{filename of foci channel image}

\item{file_DAPI, }{filename of DAPI channel image}

\item{cell_count, }{counter for successful crops around cells}

\item{mean_pix, }{Mean pixel intensity of cell crop (in SYCP3 channel)
for normalisation}

\item{annotation, }{Choice to output pipeline choices (recommended to knit)}

\item{file_base, }{filename base common to all three channels
i.e. without -MLH3.jpeg etc.}

\item{img_path, }{path containing image data to analyse}

\item{r_max}{maximum radius of blob for cropping}

\item{cx}{centre of blob x}

\item{cy}{centre of blob y}

\item{channel3_string}{Optional. String appended to the files showing the
channel illuminating cell structures. Defaults to DAPI,
if third channel == "on".}

\item{channel2_string}{String appended to the files showing the channel
illuminating synaptonemal complexes. Defaults to SYCP3}

\item{channel1_string}{String appended to the files showing the channel
illuminating foci. Defaults to MLH3}

\item{file_ext}{file extension of your images e.g. tif jpeg or png.}

\item{third_channel}{Optional, defaults to "off". Set to "on" if you would
also like crops of the third channel.}

\item{path_out, }{user specified output path. Defaults to img_path}

\item{img_orig_highres}{the original strand image with original resolution}

\item{resize_l}{length of square to resize original image to.}

\item{crowded_cells}{TRUE or FALSE, defaults to FALSE. Set to TRUE if you
have many cells in a frame that almost touch}

\item{cropping_factor}{size of cropping window square, as factor of
characteristic blob radius. Defaults to 1. May need to increase if using
watershed.}
}
\value{
Crops around all candidates in both channels
}
\description{
Creates mask for every individual cell candidate in mask
}
