% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/count_foci.R
\name{get_foci_per_cell}
\alias{get_foci_per_cell}
\title{get_foci_per_cell}
\usage{
get_foci_per_cell(
  img_file,
  offset_px,
  stage,
  strands,
  watershed_stop,
  foci_label,
  annotation,
  cell_count,
  img_orig,
  img_orig_foci,
  artificial_amp_factor,
  coincident_foci
)
}
\arguments{
\item{img_file}{cell's file name}

\item{offset_px, }{Pixel value offset used in thresholding of synaptonemal complex channel}

\item{stage, }{meiosis stage of interest. Currently count_foci determines
this with thresholding/ object properties in the synaptonemal complex channel
by previosly calling the get_pachytene function.
Note that if using this option, the count_foci function requires that the
input directory contains a folder called “pachytene” with the crops in it.}

\item{strands}{black white mask of strand channel}

\item{watershed_stop}{Stop default watershed method with "on"}

\item{foci_label}{black and white mask of foci channel}

\item{annotation, }{Choice to output pipeline choices (recommended to knit)}

\item{cell_count}{unique cell counter}

\item{img_orig}{original strand crop}

\item{img_orig_foci}{cropped foci channel}

\item{artificial_amp_factor}{amplification factor}

\item{coincident_foci}{mask of coincident foci}
}
\value{
number of foci per cell
}
\description{
creates mask for coincident foci
}
