% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/overwrite_core_tabs.R
\name{spsCoreTabReplace}
\alias{spsCoreTabReplace}
\title{Overwrite a default SPS tab}
\usage{
spsCoreTabReplace(
  replace_tab,
  app_path = getwd(),
  open_file = TRUE,
  overwrite = FALSE
)
}
\arguments{
\item{replace_tab}{one of "welcome", "module_main", "vs_main", "canvas", "about",
for the welcome tab, module home tab, custom tab home tab, Canvas tab, about tab
respectively.}

\item{app_path}{string, where is SPS project root path}

\item{open_file}{bool, open the newly created template if you are in Rstudio?}

\item{overwrite}{bool, if the template exists, overwrite it with a new, empty one?}
}
\value{
a template file
}
\description{
If you want to load your custom content on any of the default
tabs in a SPS project, you can overwrite the tab with your own UI and server
function. First, use this function to create a template for the tab you want
to replace and then fill your own content.
}
\examples{
if(interactive()){
    spsInit(project_name = "default_overwrite_demo",
            change_wd = FALSE, open_files = FALSE)
    ## try to run it for the first look
    # shiny::runApp("default_overwrite_demo")
    spsCoreTabReplace("welcome", app_path = "default_overwrite_demo")
    ## edit the file and save it.
    ## run again and watch the difference on the welcome tab.
    shiny::runApp("default_overwrite_demo")
}
}
