% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCAplot.R
\name{PCAplot}
\alias{PCAplot}
\title{PCAplot}
\usage{
PCAplot(exploredds, plotly = FALSE, savePlot = FALSE, filePlot = NULL)
}
\arguments{
\item{exploredds}{object of class \code{\link[DESeq2:DESeqTransform]{DESeq2::DESeqTransform()}}.}

\item{plotly}{logical: when \code{FALSE} (default), the \code{ggplot2} plot will be
returned. \code{TRUE} option returns the \code{plotly} version of the plot.}

\item{savePlot}{logical: when \code{FALSE} (default), the plot will not be saved.
If \code{TRUE} the plot will be saved, and requires the \code{filePlot} argument.}

\item{filePlot}{file name where the plot will be saved. For more information,
please consult the \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} function.}
}
\value{
returns an object of \code{ggplot} or \code{plotly} class.
}
\description{
This function plots a Principal Component Analysis (PCA) from
transformed expression matrix. This plot shows samples variation based on the
expression values and identifies batch effects.
}
\examples{
## Targets file
targetspath <- system.file("extdata", "targets.txt", package = "systemPipeR")
targets <- read.delim(targetspath, comment = "#")
cmp <- systemPipeR::readComp(file = targetspath, format = "matrix", 
delim = "-")
## Count table file
countMatrixPath <- system.file("extdata", "countDFeByg.xls", 
package = "systemPipeR")
countMatrix <- read.delim(countMatrixPath, row.names = 1)
## Plot
exploredds <- exploreDDS(countMatrix, targets, cmp = cmp[[1]], 
preFilter = NULL, transformationMethod = "rlog")
PCAplot(exploredds, plotly = TRUE)
}
