% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{plot_predictions}
\alias{plot_predictions}
\title{Plot the ECDF of ranks by groups}
\usage{
plot_predictions(rank, group, colors, labels, ...)
}
\arguments{
\item{rank}{A numeric vector}

\item{group}{A factor of length equal that of rank}

\item{colors}{A character vector of colors for each group}

\item{labels}{A character vector of length equal the unique values in groups}

\item{...}{Other arguments passed to points}
}
\value{
NULL.
}
\description{
Plot the cumulative distribution function of choosen value (e.g. ranks) by
a factor of the same lenght, group. Each group is given a color and a label.
}
\examples{
# generate random values
rn1 <- rnorm(100)
rn2 <- rnorm(100, 2)
e <- c(rn1, rn2)

# generate grouping variable
g <- rep(c('up', 'down'), times = c(length(rn1), length(rn2)))

plot_predictions(e,
                 group = g,
                 colors = c('red', 'green'),
                 labels = c('up', 'down'))

}
