% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terraTCGAworkspaces.R
\name{.getWorkspaceTable}
\alias{.getWorkspaceTable}
\title{Obtain the table of datasets from the Terra platform}
\usage{
.getWorkspaceTable(project = "^TCGA", cancerCode = ".*")
}
\arguments{
\item{project}{character(1) A prefix for the regex search across all public
projects on the terra platform (default: `"^TCGA"`). Usually, this does not
change.}

\item{cancerCode}{character(1) Corresponds to the TCGA cancer code (e.g,
"ACC" for AdrenoCortical Carcinoma) of interest. The default value of
(`.*`) provides all available cancer datasets.}
}
\value{
A `tibble` `data.frame` that match the project in put; by default,
  TCGA workspaces.
}
\description{
The datasets include all TCGA datasets that do not come from the Genomic
Data Commons Data Repository because those data use a different data model.
}
\keyword{internal}
