% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneCluster.spca.R
\name{tuneCluster.spca}
\alias{tuneCluster.spca}
\title{Feature Selection Optimization for sPCA method}
\usage{
tuneCluster.spca(X, ncomp = 2, test.keepX = rep(ncol(X), ncomp), ...)
}
\arguments{
\item{X}{numeric matrix (or data.frame) with features in columns and samples in rows}

\item{ncomp}{integer, number of component to include in the model}

\item{test.keepX}{vector of integer containing the different value of keepX to test for block \code{X}.}

\item{...}{other parameters to be included in the spls model (see \code{mixOmics::spca})}
}
\value{
\item{silhouette}{silhouette coef. computed for every combinasion of keepX/keepY}
\item{ncomp}{number of component included in the model}
\item{test.keepX}{list of tested keepX}
\item{block}{names of blocks}
\item{slopes}{"slopes" computed from the silhouette coef. for each keepX and keepY, used to determine the best keepX and keepY}
\item{choice.keepX}{best \code{keepX} for each component}
}
\description{
This function identify the number of feautures to keep per component and thus by cluster in \code{mixOmics::spca} 
by optimizing the silhouette coefficient, which assesses the quality of clustering.
}
\details{
For each component and for each keepX value, a spls is done from these parameters.
Then the clustering is performed and the silhouette coefficient is calculated for this clustering.

We then calculate "slopes" where keepX are the coordinates and the silhouette is the intensity.
A z-score is assigned to each slope.
We then identify the most significant slope which indicates a drop in the silhouette coefficient and thus a deterioration of the clustering.
}
\examples{
demo <- suppressWarnings(get_demo_cluster())
X <- demo$X

# tuning
tune.spca.res <- tuneCluster.spca(X = X, ncomp = 2, test.keepX = c(2:10))
keepX <- tune.spca.res$choice.keepX
plot(tune.spca.res)

# final model
spca.res <- mixOmics::spca(X=X, ncomp = 2, keepX = keepX)
plotLong(spca.res)
}
