% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/earlyDETest.R
\name{earlyDETest}
\alias{earlyDETest}
\alias{earlyDETest,SingleCellExperiment-method}
\alias{earlyDETest,list-method}
\title{Perform test of early differences between lineages}
\usage{
earlyDETest(models, ...)

\S4method{earlyDETest}{SingleCellExperiment}(
  models,
  global = TRUE,
  pairwise = FALSE,
  knots = NULL,
  nPoints = 2 * nknots(models),
  l2fc = 0,
  eigenThresh = 0.01
)

\S4method{earlyDETest}{list}(
  models,
  global = TRUE,
  pairwise = FALSE,
  knots = NULL,
  nPoints = 2 * nknots(models),
  l2fc = 0,
  eigenThresh = 0.01
)
}
\arguments{
\item{models}{The fitted GAMs, typically the output from
\code{\link{fitGAM}}.}

\item{...}{parameters including:}

\item{global}{If TRUE, test for all pairwise comparisons simultaneously.}

\item{pairwise}{If TRUE, test for all pairwise comparisons independently.}

\item{knots}{A vector of length 2 specifying the knots at the start and end 
of the region of interest.}

\item{nPoints}{The number of points to be compared between lineages.
Defaults to twice the number of knots}

\item{l2fc}{The log2 fold change threshold to test against. Note, that
this will affect both the global test and the pairwise comparisons.}

\item{eigenThresh}{Eigenvalue threshold for inverting the variance-covariance matrix
of the coefficients to use for calculating the Wald test statistics. Lower values
are more lenient to adding more information but also decrease computational stability.
This argument should in general not be changed by the user but is provided
for back-compatability. Set to \code{1e-8} to reproduce results of older
version of `tradeSeq`.}
}
\value{
A matrix with the wald statistic, the number of df and the p-value
 associated with each gene for all the tests performed. Also, for each possible
 pairwise comparision, the observed log fold changes. If the testing
 procedure was unsuccessful, the procedure will return NA test statistics,
 fold changes and p-values.
}
\description{
Perform test of differential expression patterns between lineages
in a user-defined region based on the knots of the smoothers.
}
\details{
To help the user in choosing which knots to use when defining the
branching, the \code{\link{plotGeneCount}} function has a models optional
parameter that can be used to visualize where the knots are.
}
\examples{
data(gamList, package = "tradeSeq")
earlyDETest(gamList, knots = c(1, 2), global = TRUE, pairwise = TRUE)
}
