% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/predictSmooth.R
\name{predictSmooth}
\alias{predictSmooth}
\alias{predictSmooth,SingleCellExperiment-method}
\alias{predictSmooth,list-method}
\title{predictSmooth}
\usage{
predictSmooth(models, ...)

\S4method{predictSmooth}{SingleCellExperiment}(models, gene, nPoints = 100, tidy = TRUE)

\S4method{predictSmooth}{list}(models, gene, nPoints = 100)
}
\arguments{
\item{models}{Either the \code{SingleCellExperiment} object obtained after
running \code{fitGAM}, or the specific GAM model for the corresponding gene,
if working with the list output of \code{tradeSeq}.}

\item{...}{parameters including:}

\item{gene}{Either a vector of gene names or an integer vector, corresponding
to the row(s) of the gene(s).}

\item{nPoints}{The number of points used to create the grid along the
smoother for each lineage. Defaults to 100.}

\item{tidy}{Logical: return tidy output. If TRUE, returns a \code{data.frame}
specifying lineage, gene, pseudotime and value of estimated smoother. If FALSE,
returns matrix of predicted smoother values, where each row is a gene and
each column is a point on the uniform grid along the lineage. For example,
if the trajectory consists of 2 lineages and \code{nPoints=100}, then the
returned matrix will have 2*100 columns, where the first 100 correspond to
the first lineage and columns 101-200 to the second lineage.}
}
\value{
A \code{matrix} with estimated averages.

A vector of fitted values.
}
\description{
Get smoothers estimated by \code{tradeSeq} along a
grid. This function does not return fitted values but rather the predicted
mean smoother, for a user-defined grid of points.
}
\details{
Using the gene expression model of \code{tradeSeq} available at
\url{https://www.nature.com/articles/s41467-020-14766-3#Sec2}.
the output of \code{predictSmooth} returns the \eqn{\eta_{gi}} value for 
equally space values of pseudotimes, and a constant value for \eqn{U_i} and
\eqn{N_i} (arbitraly, we select the values of \eqn{i=1}).
}
\examples{
data(gamList, package = "tradeSeq")
predictSmooth(models = gamList, gene = 1)
}
