% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{create_kmer_motif}
\alias{create_kmer_motif}
\title{Creates Transite motif object from character vector of \emph{k}-mers}
\usage{
create_kmer_motif(id, rbps, kmers, type, species, src)
}
\arguments{
\item{id}{motif id (character vector of length 1)}

\item{rbps}{character vector of names of RNA-binding proteins associated
with this motif}

\item{kmers}{character vector of \emph{k}-mers that are associated with
the motif, set of
\emph{k}-mers is
valid if
(1) all \emph{k}-mers must have the same length, (2) only hexamers or
heptamers
allowed, (3) allowed characters are A, C, G, U}

\item{type}{type of motif (e.g., \code{'HITS-CLIP'}, \code{'EMSA'},
\code{'SELEX'}, etc.)}

\item{species}{species where motif was discovered (e.g.,
\code{'Homo sapiens'})}

\item{src}{source of motif (e.g., \code{'RBPDB v1.3.1'})}
}
\value{
object of class \code{RBPMotif}
}
\description{
Takes a position weight matrix (PWM) and meta info and returns an object of
class \code{RBPMotif}.
}
\examples{
custom_motif <- create_kmer_motif(
  "custom_motif", "RBP1",
  c("AAAAAAA", "CAAAAAA"), "HITS-CLIP",
  "Homo sapiens", "user"
)
}
