% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/io.R
\name{exportGTF}
\alias{exportGTF}
\title{Export GTF}
\usage{
exportGTF(txdb, file, source = "txcutr")
}
\arguments{
\item{txdb}{transcriptome to be output}

\item{file}{a string or \code{\link{connection}} to output GTF file.
Automatically recognizes strings ending with "\strong{.gz}" for zipped output.}

\item{source}{a string to go in the \code{source} column}
}
\value{
The \code{txdb} argument is invisibly returned.
}
\description{
Exports a TxDb annotation to a GTF file
}
\examples{
library(TxDb.Scerevisiae.UCSC.sacCer3.sgdGene)

## load annotation
txdb <- TxDb.Scerevisiae.UCSC.sacCer3.sgdGene

## restrict to 'chrI' transcripts
seqlevels(txdb) <- c("chrI")

## last 500 nts per tx
txdb_w500 <- truncateTxome(txdb)

## export uncompressed
outfile <- tempfile("sacCer3.sgdGene.w500", fileext=".gtf")
exportGTF(txdb_w500, outfile)

## export compressed
outfile <- tempfile("sacCer3.sgdGene.w500", fileext=".gtf.gz")
exportGTF(txdb_w500, outfile)

}
