% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoSPIN.r
\name{autoSPIN}
\alias{autoSPIN}
\title{A wrapper function for autoSPIN sorting method}
\usage{
autoSPIN(data, data_type = c("linear", "cyclical"),
  sorting_method = c("STS", "neighborhood"), alpha = 0.2, sigma_width = 1,
  no_randomization = 20, window_perc_range = c(0.1, 0.9),
  window_size_incre_perct = 0.05)
}
\arguments{
\item{data}{An log2 transformed expresssion matrix containing n-rows of cells and m-cols of genes.}

\item{data_type}{A character string indicating the type of progression, i.e. 'linear' (strictly linear) or
'cyclical' (cyclically linear).}

\item{sorting_method}{A character string indicating the choice of SPIN sorting method, i.e. 'STS' (Side-to-Side)
or 'Neighborhood'.}

\item{alpha}{A fraction value denoting the size of locality used for calculating the summed local variance.}

\item{sigma_width}{An integer number denoting the degree of spread of the gaussian distribution which
is used for computing weight matrix for Neighborhood sorting method.}

\item{no_randomization}{An integer number indicating the number of repeated sorting, each of which
uses randomly selected initial cell position.}

\item{window_perc_range}{A fraction value indicating the range of window size to be examined during local refinement.}

\item{window_size_incre_perct}{A fraction value indicating the step size at each iteration
for incrementing window size.}
}
\value{
A data frame containing single column of ordered sample IDs.
}
\description{
A wrapper function for autoSPIN method which implements optimized local refinement using the selected
SPIN sorting method, i.e. STS or Neighborhood.
}
\examples{
set.seed(15)
da <- iris[sample(150, 150, replace = FALSE), ]
rownames(da) <- paste0('spl_',seq(1,nrow(da)))
d <- da[,1:4]
dl <- da[,5,drop=FALSE]
res <- autoSPIN(data = d)
dl <- dl[match(res$SampleID,rownames(dl)),]
annot <- data.frame(id = seq(1,nrow(res)), label=dl, stringsAsFactors = FALSE)
#ggplot(annot, aes(x=id, y=id, colour = label)) + geom_point() + theme_bw()
}

