% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uwmwRes_Class.R
\docType{class}
\name{uwmwRes-class}
\alias{uwmwRes-class}
\alias{uwmwRes}
\title{Class uwmwRes}
\description{
This class represents the results of the unified Wilcoxon-Mann-Whitney test. It contains all necessary information for the vulcano and forest plots. For this class a number of methods is foreseen, among which accessors for every slot.
}
\note{
For this class, \code{\link{show}} and \code{\link{length}} methods are defined. \code{\link{length}} will give you the number of features.
}
\section{Slots}{

\describe{
   \item{\code{type}:}{object of class \code{"character"}, containing the type of analysis (either H or O, see \code{\link{uWMW}} for more details.)}
   \item{\code{housekeeping}:}{object of class \code{"character"}, containing either NULL or the names of the housekeeping features used in the HME version of \code{\link{uWMW}}.}
   \item{\code{names}:}{object of class \code{"character"}, containing the names of the features that were used in the test.}
   \item{\code{logOR}:}{object of class \code{"numeric"}, containing the estimated log odds ratios from the uWMW test.}
   \item{\code{se}:}{object of class \code{"numeric"}, containing the standard errors on the estimated log odds ratios.}
   \item{\code{OR}:}{object of class \code{"numeric"}, containing the odds ratios estimated by the uWMW test. This slot is accessed using the function \code{oddsRatio()}}
   \item{\code{z.value}:}{object of class \code{"numeric"}, containing the Z values related to the odds ratios estimated by the uWMW test. These z-values relate to the chance that a specific feature is up- or downregulated, and are used as the basis for determining the p values.}
   \item{\code{p.value}:}{object of class \code{"numeric"}, containing the p values related to the odds ratios estimated by the uWMW test. These p-values relate to the chance that a specific feature is up- or downregulated.}
   \item{\code{coef}:}{object of class \code{"numeric"}, containing the estimated coefficient of the PIM model that's used in the uWMW test.}
   \item{\code{vcov}:}{matrix of class \code{"numeric"}, containing the variance-covariance matrix related to the estimated coefficients.}  
   \item{\code{id}:}{vector of class \code{"numeric"}, containing the sorting order of the features. This slot is set using the function \code{sort}}  
   \item{\code{orderedBy}:}{character value, indicating whether the object contains an order and if so, based on which slot. Possible values are "none", "p", "z", "or", "se" or "name". Defaults to "none".}
   \item{\code{groupinfo}:}{character vector of length 2, indicating the groups. This slot is mainly used to show how the probabilistic indices are calculated.}  
}
}

\seealso{
\code{\link{uwmw_Accessors}}
}
\author{
Joris Meys
}
