% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.r
\name{pruneRegulon}
\alias{pruneRegulon}
\title{Prune Regulons}
\usage{
pruneRegulon(regulon, cutoff = 50, adaptive = TRUE,
  eliminate = FALSE, wm = NULL)
}
\arguments{
\item{regulon}{Object of class regulon}

\item{cutoff}{Number indicating the maximum size for the regulons (maximum number of target genes)}

\item{adaptive}{Logical, whether adaptive size should be used (i.e. sum(likelihood^2))}

\item{eliminate}{Logical whether regulons smalles than \code{cutoff} should be eliminated}

\item{wm}{Optional numeric vector of weights (0; 1) for the genes}
}
\value{
Prunned regulon
}
\description{
This function limits the maximum size of the regulons
}
\examples{
data(bcellViper, package="bcellViper")
hist(sapply(regulon, function(x) sum(x$likelihood)/max(x$likelihood)), nclass=20)
preg <- pruneRegulon(regulon, 400)
hist(sapply(preg, function(x) sum(x$likelihood)/max(x$likelihood)), nclass=20)
}
\seealso{
\code{\link{viper}}, \code{\link{msviper}}
}
