% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shadow.r
\name{shadow}
\alias{shadow}
\title{Shadow analysis for msviper objects}
\usage{
shadow(mobj, regulators = 0.01, targets = 10, shadow = 0.01,
  per = 1000, nullmodel = NULL, minsize = NULL,
  adaptive.size = NULL, iterative = NULL, seed = 1, cores = 1,
  verbose = TRUE)
}
\arguments{
\item{mobj}{msviper object generated by \code{msviper}}

\item{regulators}{This parameter represent different ways to select a subset of regulators for performing the shadow analysis, it can be either a p-value cutoff, the total number of regulons to be used for computing the shadow effect, or a vector of regulator ids to be considered}

\item{targets}{Integer indicating the minimum number of common targets to compute shadow analysis}

\item{shadow}{Number indicating the p-value threshold for the shadow effect}

\item{per}{Integer indicating the number of permutations}

\item{nullmodel}{Null model in marix format}

\item{minsize}{Integer indicating the minimum size allowed for the regulons}

\item{adaptive.size}{Logical, whether the target weight should be considered when computing the regulon size}

\item{iterative}{Logical, whether a two step analysis with adaptive redundancy estimation should be performed}

\item{seed}{Integer indicating the seed for the permutations, 0 for disable it}

\item{cores}{Integer indicating the number of cores to use (only 1 in Windows-based systems)}

\item{verbose}{Logical, whether progression messages should be printed in the terminal}
}
\value{
An updated msviper object with an additional slot (shadow) containing the shadow pairs
}
\description{
This function performs shadow analysis on msviper objects
}
\examples{
data(bcellViper, package="bcellViper")
sig <- rowTtest(dset, "description", c("CB", "CC"), "N")$statistic
dnull <- ttestNull(dset, "description", c("CB", "CC"), "N", per=100) # Only 100 permutations to reduce computation time, but it is recommended to perform at least 1000 permutations
mra <- msviper(sig, regulon, dnull)
mra <- shadow(mra, regulators=10)
summary(mra)
}
\seealso{
\code{\link{msviper}}
}
