% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal.r
\name{shadowRegulon}
\alias{shadowRegulon}
\title{Correction for pleiotropy}
\usage{
shadowRegulon(ss, nes, regul, regulators = 0.05, shadow = 0.05,
  targets = 10, penalty = 2, method = c("absolute", "adaptive"))
}
\arguments{
\item{ss}{Named vector containing the gene expression signature}

\item{nes}{Named vector containing the normalized enrichment scores}

\item{regul}{Regulon object}

\item{regulators}{Number indicating the number of top regulators to consider for the analysis or the p-value threshold for considering significant regulators}

\item{shadow}{Number indicating the p-value threshold for considering a significant shadow effect}

\item{targets}{Integer indicating the minimal number of overlaping targets to consider a pair of regulators for pleiotropy analysis}

\item{penalty}{Number higher than 1 indicating the penalty for the pleiotropic interactions. 1 = no penalty}

\item{method}{Character string indicating the method to use for computing the pleiotropy, either absolute or adaptive}
}
\value{
Corrected regulon object
}
\description{
This function penalyze the regulatory interactions based on pleiotropy analysis
}
