% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsea.R
\name{dpareto}
\alias{dpareto}
\title{Probability density of Pareto distributions}
\usage{
dpareto(x, threshold = 1, exponent, log = FALSE)
}
\arguments{
\item{x}{Data vector of log probability densities}

\item{threshold}{numeric value to define the start of the tail}

\item{exponent}{the exponent obtained from the pareto.fit function}

\item{log}{logical, should the values be log-transformed?}
}
\value{
Vector of (log) probability densities
}
\description{
Gives NA on values below the threshold
}
\examples{
set.seed(1)
x<-abs(rnorm(1000))
n<-length(x)
exponent<-1+n/sum(log(x))
dp<-dpareto(x,exponent=exponent)
plot(dp)
}
