% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generic.R
\name{textplot2}
\alias{textplot2}
\title{textplot2 - An x y plot of non-overlapping text}
\usage{
textplot2(
  x,
  y,
  words,
  cex = 1,
  pch = 16,
  pointcolor = "#FFFFFF00",
  new = TRUE,
  show.lines = TRUE,
  ...
)
}
\arguments{
\item{x}{x coordinates}

\item{y}{y coordinates}

\item{words}{the text to plot}

\item{cex}{font size}

\item{pch}{pch parameter for the plotted points}

\item{pointcolor}{a string specifying the color of the points
(default #FFFFFF00)}

\item{new}{should a new plot be created}

\item{show.lines}{if true, then lines are plotted between x,y and the word,
for those words not covering their x,y coordinates}

\item{...}{Additional parameters to be passed to wordlayout and text.}
}
\value{
nothing
}
\description{
This function is an extension of the \code{'textplot'} function from the
\code{'wordcloud'} package, with the extra functionality of specifiying the
color of the points
}
\examples{
obj_names<-apply(expand.grid(LETTERS,LETTERS),1,paste,collapse='')
a<-setNames(runif(26*26),obj_names)
b<-setNames(rnorm(26*26),obj_names)
plot(a,b,pch=20,col='grey')
top<-names(sort(-a))[1:50]
textplot2(a[top],b[top],words=top,new=FALSE,pointcolor='black')
}
