% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PValues.R
\name{.gpdFittedPValue}
\alias{.gpdFittedPValue}
\title{Compute p-value based on generalized Pareto distribution fitting}
\usage{
.gpdFittedPValue(val, distr.ordered)
}
\arguments{
\item{val}{value of a specific test statistic, based on original group labels}

\item{distr.ordered}{vector of values, in decreasing order, of the test statistic obtained by repeatedly permuting the original group labels}
}
\value{
A vector of three, see Schefzik et al. (2020) for details:
\itemize{
\item pvalue.gpd: p-value obtained when using the GPD fitting
test
\item ad.pval: p-value of the
Anderson-Darling test to check whether the GPD actually fits the data well
\item N.exc: number of exceedances
(starting with 250 and iteratively decreased by 10 if necessary) that are
required to obtain a good GPD fit, i.e. p-value of Anderson-Darling test
\eqn{\geq 0.05}
}
}
\description{
Computes a p-value based on a generalized Pareto distribution (GPD) fitting. This procedure may be used in the semi-parametric 2-Wasserstein distance-based test to estimate small p-values accurately, instead of obtaining the p-value from a permutation test.
}
\references{
Schefzik, R., Flesch, J., and Goncalves, A. (2020). waddR: Using the 2-Wasserstein distance to identify differences between distributions in two-sample testing, with application to single-cell RNA-sequencing data.
}
