% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WassersteinTest.R
\name{.wassPermProcedure}
\alias{.wassPermProcedure}
\title{Permutation procedure that calculates the squared 2-Wasserstein distances for
random shuffles of two input samples representing two conditions}
\usage{
.wassPermProcedure(x, y, permnum)
}
\arguments{
\item{x}{sample (vector) representing the distribution of
condition \eqn{A}}

\item{y}{sample (vector) representing the distribution of
condition \eqn{B}}

\item{permnum}{number of permutations to be
performed}
}
\value{
Vector with squared 2-Wasserstein distances computed for random
 shuffles of the two input samples
}
\description{
Permutation procedure that calculates the squared 2-Wasserstein distances for
random shuffles of two input samples representing two conditions \eqn{A} and \eqn{B}, respectively (i.e. the elements of the pooled sample vector are randomly assigned to either condition \eqn{A} or condition \eqn{B}, where the sample sizes are as in the original samples).
}
