% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export.R
\name{exportHighConfSub}
\alias{exportHighConfSub}
\title{Export high-confidence substitutions as BED track}
\usage{
exportHighConfSub(highConfSub, filename = 'highConfSub.bed',
trackname = 'highConfSub', description = 'highConfSub')
}
\arguments{
\item{highConfSub}{GRanges object containing high-confidence substitution
sites as returned by the \link{getHighConfSub} function}

\item{filename}{A character defining the BED file name. Default to
"wavClusters.bed"}

\item{trackname}{A character defining the track.name of the BED file.
Default to "wavClusters"}

\item{description}{A character defining the description of the BED file.
Default to "wavClusters"}
}
\value{
A BED file of the exported GRanges object
}
\description{
Export high-confidence substitutions as BED track, compatible with the UCSC
genome browser
}
\note{
Substitutions are color coded according to their strand information
(red for the plus strand, blue for the minus strand).
}
\seealso{
\code{\link{getHighConfSub}}
}
\author{
Federico Comoglio
}
\keyword{postprocessing}
