% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getExpInterval.R
\name{getExpInterval}
\alias{getExpInterval}
\title{Identify the interval of relative substitution frequencies dominated by
experimental induction.}
\usage{
getExpInterval(model, bayes = TRUE, leftProb, rightProb, plot = TRUE)
}
\arguments{
\item{model}{A list containing the model as returned by the function
\code{fitMixtureModel}}

\item{bayes}{Logical, if TRUE the Bayes classifier (cutoff at posterior
class probabilities >= 0.5) is applied. If FALSE, custom cutoff values
should be provided through leftProb and rightProb. Default is TRUE.}

\item{leftProb}{Numeric, the posterior probability corresponding to the left
boundary (start) of the high confidence RSF interval.}

\item{rightProb}{Numeric, the posterior probability corresponding to the
right boundary (end) of the high confidence RSF interval.}

\item{plot}{Logical, if TRUE diagnostics plot showing the model components,
log odds and the computed posterior with highlighted identified RSF interval
are returned.}
}
\value{
A list with two numeric slots, corresponding to the extremes of the
RSF interval (RSF support). \item{supportStart}{start of the high confidence
RSF interval} \item{supportEnd}{end of the high confidence RSF interval}
}
\description{
Identifies the interval/support of relative substitution frequencies (RSFs)
dominated by the second model component, i.e. by the probability of being
induced by the experimental procedure. In addition, this function can be
used to generate diagnostic plots of the model fit, representing (i) model
densities and log odds ratio (ii) the posterior class probability, i.e. the
probability of a given observation being generated by experimental
induction.
}
\examples{

data( model )

#default
support <- getExpInterval( model = model, bayes = TRUE, plot = TRUE )
support

#custom interval (based, e.g. on visual inspection of posterior class probability 
# or evaluation of FDR using the estimateFDRF function)
support <- getExpInterval( model = model, leftProb = 0.2, rightProb = 0.7, plot = TRUE )
support

}
\references{
Sievers C, Schlumpf T, Sawarkar R, Comoglio F and Paro R. (2012) Mixture
models and wavelet transforms reveal high confidence RNA-protein interaction
sites in MOV10 PAR-CLIP data, Nucleic Acids Res. 40(20):e160. doi:
10.1093/nar/gks697

Comoglio F, Sievers C and Paro R (2015) Sensitive and highly resolved identification
of RNA-protein interaction sites in PAR-CLIP data, BMC Bioinformatics 16, 32.
}
\seealso{
\code{\link{fitMixtureModel}} \code{\link{getHighConfSub}}
\code{\link{estimateFDR}}
}
\author{
Federico Comoglio and Cem Sievers
}
\keyword{core}
\keyword{graphics}
