% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotStatistics.R
\name{plotStatistics}
\alias{plotStatistics}
\title{Pairs plot visualization of clusters statistics}
\usage{
plotStatistics(clusters, corMethod = 'spearman', lower =
panel.smooth, ...)
}
\arguments{
\item{clusters}{GRanges object containing individual clusters as identified
by the \link{getClusters} function}

\item{corMethod}{A character defining the correlation coefficient to be
computed. See the help page of the \code{cor} function for possible options.
Default is "spearman". Hence, rank-based Spearman's correlation coefficients
are computed}

\item{lower}{A function compatible with the \code{lower} panel argument of
the \code{pairs} function}

\item{...}{Additional parameters to be passed to the \code{pairs} function}
}
\value{
called for its effect
}
\description{
Graphical representation of cluster statistics, featuring pairwise
correlations in the upper panel.
}
\examples{

require(BSgenome.Hsapiens.UCSC.hg19)

data( model, package = "wavClusteR" ) 

filename <- system.file( "extdata", "example.bam", package = "wavClusteR" )
example <- readSortedBam( filename = filename )
countTable <- getAllSub( example, minCov = 10, cores = 1 )
highConfSub <- getHighConfSub( countTable, supportStart = 0.2, supportEnd = 0.7, substitution = "TC" )
coverage <- coverage( example )
clusters <- getClusters( highConfSub = highConfSub, 
                         coverage = coverage, 
                         sortedBam = example, 
	                        threshold = 2 ) 

fclusters <- filterClusters( clusters = clusters, 
		             highConfSub = highConfSub, 
        		     coverage = coverage,
			     model = model, 
			     genome = Hsapiens, 
		             refBase = 'T', 
		             minWidth = 12 )
plotStatistics( clusters = fclusters )

}
\seealso{
\code{\link{getClusters}}
}
\author{
Federico Comoglio
}
\keyword{graphics}
\keyword{postprocessing}
