% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convenienceWrappers.R
\name{plotCoverageFromEnsembldb}
\alias{plotCoverageFromEnsembldb}
\title{Plot read coverage directly from ensembldb object.}
\usage{
plotCoverageFromEnsembldb(ensembldb, gene_names, transcript_ids = NULL, ...)
}
\arguments{
\item{ensembldb}{ensembldb object.}

\item{gene_names}{List of gene names to be plotted.}

\item{transcript_ids}{Optional list of transcript ids to be plotted.}

\item{...}{Additional parameters to be passed to plotCoverage.}
}
\value{
ggplot2 object
}
\description{
A wrapper around the plotCoverage function. See the documentation for (\code{\link[wiggleplotr]{plotCoverage}}) 
for more information.
}
\examples{
require("EnsDb.Hsapiens.v86")
require("dplyr")
require("GenomicRanges")
sample_data = dplyr::data_frame(sample_id = c("aipt_A", "aipt_C", "bima_A", "bima_C"), 
 condition = factor(c("Naive", "LPS", "Naive", "LPS"), levels = c("Naive", "LPS")), 
 scaling_factor = 1) \%>\%
 dplyr::mutate(bigWig = system.file("extdata",  paste0(sample_id, ".str2.bw"), package = "wiggleplotr"))
 
track_data = dplyr::mutate(sample_data, track_id = condition, colour_group = condition)
\dontrun{
plotCoverageFromEnsembldb(EnsDb.Hsapiens.v86, "NCOA7", transcript_ids = c("ENST00000438495", "ENST00000392477"), 
track_data, heights = c(2,1), fill_palette = getGenotypePalette())
}
}
