% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions-XChromatograms.R,
%   R/functions-XChromatogram.R, R/methods-XChromatogram.R,
%   R/methods-XChromatograms.R
\name{XChromatograms}
\alias{XChromatograms}
\alias{XChromatogram}
\alias{XChromatogram-class}
\alias{XChromatograms-class}
\alias{coerce,MChromatograms,XChromatograms-method}
\alias{chromPeaks,XChromatogram-method}
\alias{chromPeaks<-,XChromatogram-method}
\alias{plot,XChromatogram,ANY-method}
\alias{filterMz,XChromatogram-method}
\alias{filterRt,XChromatogram-method}
\alias{hasChromPeaks,XChromatogram-method}
\alias{dropFilledChromPeaks,XChromatogram-method}
\alias{chromPeakData,XChromatogram-method}
\alias{chromPeakData<-,XChromatogram-method}
\alias{refineChromPeaks,XChromatogram,MergeNeighboringPeaksParam-method}
\alias{filterChromPeaks,XChromatogram-method}
\alias{transformIntensity,XChromatogram-method}
\alias{hasChromPeaks,XChromatograms-method}
\alias{hasFilledChromPeaks,XChromatograms-method}
\alias{chromPeaks,XChromatograms-method}
\alias{chromPeakData,XChromatograms-method}
\alias{filterMz,XChromatograms-method}
\alias{filterRt,XChromatograms-method}
\alias{plot,XChromatograms,ANY-method}
\alias{processHistory,XChromatograms-method}
\alias{hasFeatures,XChromatograms-method}
\alias{dropFeatureDefinitions,XChromatograms-method}
\alias{groupChromPeaks,XChromatograms,PeakDensityParam-method}
\alias{featureDefinitions,XChromatograms-method}
\alias{[,XChromatograms,ANY,ANY,ANY-method}
\alias{featureValues,XChromatograms-method}
\alias{plotChromPeakDensity,XChromatograms-method}
\alias{dropFilledChromPeaks,XChromatograms-method}
\alias{refineChromPeaks,XChromatograms,MergeNeighboringPeaksParam-method}
\alias{filterChromPeaks,XChromatograms-method}
\alias{transformIntensity,XChromatograms-method}
\title{Containers for chromatographic and peak detection data}
\usage{
XChromatograms(data, phenoData, featureData, chromPeaks, chromPeakData, ...)

XChromatogram(
  rtime = numeric(),
  intensity = numeric(),
  mz = c(NA_real_, NA_real_),
  filterMz = c(NA_real_, NA_real_),
  precursorMz = c(NA_real_, NA_real_),
  productMz = c(NA_real_, NA_real_),
  fromFile = integer(),
  aggregationFun = character(),
  msLevel = 1L,
  chromPeaks,
  chromPeakData
)

\S4method{chromPeaks}{XChromatogram}(
  object,
  rt = numeric(),
  mz = numeric(),
  ppm = 0,
  type = c("any", "within", "apex_within"),
  msLevel
)

\S4method{chromPeaks}{XChromatogram}(object) <- value

\S4method{plot}{XChromatogram,ANY}(
  x,
  col = "#00000060",
  lty = 1,
  type = "l",
  xlab = "retention time",
  ylab = "intensity",
  main = NULL,
  peakType = c("polygon", "point", "rectangle", "none"),
  peakCol = "#00000060",
  peakBg = "#00000020",
  peakPch = 1,
  ...
)

\S4method{filterMz}{XChromatogram}(object, mz, ...)

\S4method{filterRt}{XChromatogram}(object, rt, ...)

\S4method{hasChromPeaks}{XChromatogram}(object)

\S4method{dropFilledChromPeaks}{XChromatogram}(object)

\S4method{chromPeakData}{XChromatogram}(object)

\S4method{chromPeakData}{XChromatogram}(object) <- value

\S4method{refineChromPeaks}{XChromatogram,MergeNeighboringPeaksParam}(object, param = MergeNeighboringPeaksParam())

\S4method{filterChromPeaks}{XChromatogram}(object, method = c("keepTop"), ...)

\S4method{transformIntensity}{XChromatogram}(object, FUN = identity)

\S4method{hasChromPeaks}{XChromatograms}(object)

\S4method{hasFilledChromPeaks}{XChromatograms}(object)

\S4method{chromPeaks}{XChromatograms}(
  object,
  rt = numeric(),
  mz = numeric(),
  ppm = 0,
  type = c("any", "within", "apex_within"),
  msLevel
)

\S4method{chromPeakData}{XChromatograms}(object)

\S4method{filterMz}{XChromatograms}(object, mz, ...)

\S4method{filterRt}{XChromatograms}(object, rt, ...)

\S4method{plot}{XChromatograms,ANY}(
  x,
  col = "#00000060",
  lty = 1,
  type = "l",
  xlab = "retention time",
  ylab = "intensity",
  main = NULL,
  peakType = c("polygon", "point", "rectangle", "none"),
  peakCol = "#00000060",
  peakBg = "#00000020",
  peakPch = 1,
  ...
)

\S4method{processHistory}{XChromatograms}(object, fileIndex, type)

\S4method{hasFeatures}{XChromatograms}(object, ...)

\S4method{dropFeatureDefinitions}{XChromatograms}(object, ...)

\S4method{groupChromPeaks}{XChromatograms,PeakDensityParam}(object, param)

\S4method{featureDefinitions}{XChromatograms}(
  object,
  mz = numeric(),
  rt = numeric(),
  ppm = 0,
  type = c("any", "within", "apex_within")
)

\S4method{[}{XChromatograms,ANY,ANY,ANY}(x, i, j, drop = TRUE)

\S4method{featureValues}{XChromatograms}(
  object,
  method = c("medret", "maxint", "sum"),
  value = "into",
  intensity = "into",
  missing = NA,
  ...
)

\S4method{plotChromPeakDensity}{XChromatograms}(
  object,
  param,
  col = "#00000060",
  xlab = "retention time",
  main = NULL,
  peakType = c("polygon", "point", "rectangle", "none"),
  peakCol = "#00000060",
  peakBg = "#00000020",
  peakPch = 1,
  simulate = TRUE,
  ...
)

\S4method{dropFilledChromPeaks}{XChromatograms}(object)

\S4method{refineChromPeaks}{XChromatograms,MergeNeighboringPeaksParam}(object, param = MergeNeighboringPeaksParam())

\S4method{filterChromPeaks}{XChromatograms}(object, method = c("keepTop"), ...)

\S4method{transformIntensity}{XChromatograms}(object, FUN = identity)
}
\arguments{
\item{data}{For \code{XChromatograms}: \code{list} of \code{Chromatogram} or
\code{XChromatogram} objects.}

\item{phenoData}{For \code{XChromatograms}: either a \code{data.frame},
\code{AnnotatedDataFrame} describing the
phenotypical information of the samples.}

\item{featureData}{For \code{XChromatograms}: either a \code{data.frame} or
\code{AnnotatedDataFrame} with additional information for each row of
chromatograms.}

\item{chromPeaks}{For \code{XChromatogram}: \code{matrix} with required columns
\code{"rt"}, \code{"rtmin"}, \code{"rtmax"}, \code{"into"}, \code{"maxo"} and \code{"sn"}.
For \code{XChromatograms}: \code{list}, same length than \code{data}, with the
chromatographic peaks for each chromatogram. Each element has to be
a \code{matrix}, the ordering has to match the order of the chromatograms
in \code{data}.}

\item{chromPeakData}{For \code{XChromatogram}: \code{DataFrame} with optional
additional annotations for each chromatographic peak. The number of rows
has to match the number of chromatographic peaks.}

\item{...}{For \code{filterChromPeaks}: additional parameters defining how to
filter chromatographic peaks. See function description below for details.}

\item{rtime}{For \code{XChromatogram}: \code{numeric} with the retention times
(length has to be equal to the length of \code{intensity}).}

\item{intensity}{For \code{XChromatogram}: \code{numeric} with the intensity values
(length has to be equal to the length of \code{rtime}).

\if{html}{\out{<div class="sourceCode">}}\preformatted{For `featureValues`: `character(1)` specifying the name
of the column in `chromPeaks(object)` containing the intensity value
of the peak that should be used for the `method = "maxint"` conflict
resolution if.
}\if{html}{\out{</div>}}}

\item{mz}{For \code{XChromatogram}: \code{numeric(2)} representing the m/z value
range (min, max) on which the chromatogram was created. This is
supposed to contain the \emph{real} range of m/z values in contrast
to the \code{filterMz} below.
For \code{chromPeaks} and \code{featureDefinitions}: \code{numeric(2)} defining the
m/z range for which chromatographic peaks or features should be returned.
For \code{filterMz}: \code{numeric(2)} defining the m/z range for which
chromatographic peaks should be retained.#'}

\item{filterMz}{For \code{XChromatogram}: \code{numeric(2)} representing the m/z
value range (min, max) that was used to filter the original object
on m/z dimension. If not applicable use \code{filterMz = c(0, 0)}.}

\item{precursorMz}{For \code{XChromatogram}: \code{numeric(2)} for SRM/MRM transitions.
Represents the mz of the precursor ion. See details for more information.}

\item{productMz}{For \code{XChromatogram}: \code{numeric(2)} for SRM/MRM transitions.
Represents the mz of the product. See details for more information.}

\item{fromFile}{For \code{XChromatogram}: \code{integer(1)} the index of the file
within the \code{OnDiskMSnExp} or \code{MSnExp} object from which the chromatogram
was extracted.}

\item{aggregationFun}{For \code{XChromatogram}: \code{character(1)} specifying the
function that was used to aggregate intensity values for the same
retention time across the m/z range.}

\item{msLevel}{For \code{XChromatogram}: \code{integer} with the MS level from which
the chromatogram was extracted.
For \code{chromPeaks} and \code{chromPeakData}: extract chromatographic peaks of a
certain MS level.}

\item{object}{An \code{XChromatogram} or \code{XChromatograms} object.}

\item{rt}{For \code{chromPeaks} and \code{featureDefinitions}: \code{numeric(2)} defining
the retention time range for which chromatographic peaks or features
should be returned.
For \code{filterRt}: \code{numeric(2)} defining the retention time range to
reduce \code{object} to.}

\item{ppm}{For \code{chromPeaks} and \code{featureDefinitions}: \code{numeric(1)} defining
a ppm to expand the provided m/z range.}

\item{type}{For \code{chromPeaks} and \code{featureDefinitions}: \code{character(1)}
defining which peaks or features to return if \code{rt} or \code{mz} is provided:
\code{"any"} (default) return all peaks that are even
partially overlapping with \code{rt}, \code{"within"} return peaks that are
completely within \code{rt} and \code{"apex_within"} return peaks which apex
is within \code{rt}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{For `plot`: what type of plot should be used for the
chromatogram (such as `"l"` for lines, `"p"` for points etc), see help
of [plot()] in the `graphics` package for more details.
For `processHistory`: restrict returned processing steps to specific
types. Use [processHistoryTypes()] to list all supported values.
}\if{html}{\out{</div>}}}

\item{value}{For \verb{chromPeaks<-}: a numeric \code{matrix} with required columns
\code{"rt"}, \code{"rtmin"}, \code{"rtmax"}, \code{"into"} and \code{"maxo"}.

\if{html}{\out{<div class="sourceCode">}}\preformatted{For `featureValues`: `character(1)` specifying the name of the column in
`chromPeaks(object)` that should be returned or `"index"` (default) to
return the index of the peak associated with the feature in each sample.
To return the integrated peak area instead of the index use
`value = "into"`.
}\if{html}{\out{</div>}}}

\item{x}{For \code{plot}: an \code{XChromatogram} or \code{XChromatograms} object.}

\item{col}{For \code{plot}: the color to be used to draw the chromatogram.}

\item{lty}{For \code{plot} and \code{plotChromPeakDensity}: the line type.}

\item{xlab}{For \code{plot} and \code{plotChromPeakDensity}: the x axis label.}

\item{ylab}{For \code{plot}: the y axis label.}

\item{main}{For \code{plot} and \code{plotChromPeakDensity}: an optional title for
the plot.}

\item{peakType}{For \code{plot} and \code{plotChromPeakDensity}:
\code{character(1)} defining how (and if) identified chromatographic peak
within the chromatogram should be plotted. Options
are \code{"polygon"} (default): draw the peak borders with the \code{peakCol} color
and fill the peak area with the \code{peakBg} color, \code{"point"}: indicate the
peak's apex with a point, \code{"rectangle"}: draw a rectangle around the
identified peak and \code{"none"}: don't draw peaks.}

\item{peakCol}{For \code{plot} and \code{plotChromPeakDensity}: the foreground color
for the peaks. For \code{peakType = "polygon"} and \code{peakType = "rectangle"}
this is the color for the border. Use \code{NA} to not use a foreground
color. This should either be a single color or a vector of colors with
the same length than \code{chromPeaks(x)} has rows.}

\item{peakBg}{For \code{plot} and \code{plotChromPeakDensity}: the background color
for the peaks. For \code{peakType = "polygon"} and \code{peakType = "rectangle"}
the peak are or rectangle will be filled with this color. Use \code{NA} to
skip. This should be either a single color or a vector of colors with
the same length than \code{chromPeaks(x)} has rows.}

\item{peakPch}{For \code{plot} and \code{plotChromPeakDensity}: the point character
to be used for \code{peakType = "point"}. See \code{\link[=plot]{plot()}} in the \code{graphics}
package for more details.}

\item{param}{For \code{groupChromPeaks} and \code{plotChromPeakDensity}: a
\code{\link[=PeakDensityParam]{PeakDensityParam()}} object with the settings for the \emph{peak density}
correspondence analysis algorithm.}

\item{method}{For \code{featureValues}: \code{character(1)} specifying the method to
resolve multi-peak mappings within the sample sample, i.e. to select
the \emph{representative} peak for a feature for which more than one peak
was assigned in one sample. Options are \code{"medret"} (default): select the
peak closest to the median retention time of the feature, \code{"maxint"}:
select the peak with the largest signal and \code{"sum"}: sum the values
of all peaks (only if \code{value} is \code{"into"} or \code{"maxo"}).
For \code{filterChromPeaks}: \code{character(1)} defining the method that should
be used to filter chromatographic peaks. See help on \code{filterChromPeaks}
below for details.}

\item{FUN}{For \code{transformIntensity}: a function to transform the intensity
values of \code{object}.}

\item{fileIndex}{For \code{processHistory}: optional \code{integer} specifying the
index of the files/samples for which the \link{ProcessHistory} objects should
be returned.}

\item{i}{For \code{[}: \code{integer} with the row indices to subset the
\code{XChromatograms} object.}

\item{j}{For \code{[}: \code{integer} with the column indices to subset the
\code{XChromatograms} object.}

\item{drop}{For \code{[}: \code{logical(1)} whether the dimensionality should be
dropped (if possible). Defaults to \code{drop = TRUE}, thus, if length of \code{i}
and \code{j} is 1 a \code{XChromatogram} is returned. Note that \code{drop} is ignored
if length of \code{i} or \code{j} is larger than 1, thus a \code{XChromatograms} is
returned.}

\item{missing}{For \code{featureValues}: how missing values should be reported.
Allowed values are \code{NA} (default), a \code{numeric(1)} to replace \code{NA}s with
that value or \code{missing = "rowmin_half"} to replace \code{NA}s with half
of the row's minimal (non-missing) value.}

\item{simulate}{For \code{plotChromPeakDensity}: \code{logical(1)} whether a
correspondence analysis should be \emph{simulated} based on the available
data and the provided \code{\link[=PeakDensityParam]{PeakDensityParam()}} \code{param} argument. See
section \emph{Correspondence analysis} for details.}
}
\value{
See help of the individual functions.
}
\description{
The \code{XChromatogram} object allows to store chromatographic data (e.g.
an extracted ion chromatogram) along with identified chromatographic peaks
within that data. The object inherits all functions from the
\code{\link[MSnbase:Chromatogram-class]{MSnbase::Chromatogram()}} object in the \code{MSnbase} package.

Multiple \code{XChromatogram} objects can be stored in a \code{XChromatograms} object.
This class extends \code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}} from the \code{MSnbase} package
and allows thus to arrange chromatograms in a matrix-like structure, columns
representing samples and rows m/z-retention time ranges.

All functions are described (grouped into topic-related sections) after the
\strong{Arguments} section.
}
\note{
Highlighting the peak area(s) in an \code{XChromatogram} or \code{XChromatograms}
object (\code{plot} with \code{peakType = "polygon"}) draws a polygon representing
the displayed chromatogram from the peak's minimal retention time to the
maximal retention time. If the \code{XChromatograms} was extracted from an
\code{\link[=XCMSnExp]{XCMSnExp()}} object with the \code{\link[=chromatogram]{chromatogram()}} function this might not
represent the actual identified peak area if the m/z range that was
used to extract the chromatogram was larger than the peak's m/z.
}
\section{Creation of objects}{


Objects can be created with the contructor function \code{XChromatogram} and
\code{XChromatograms}, respectively. Also, they can be coerced from
\code{\link[MSnbase:Chromatogram-class]{MSnbase::Chromatogram()}} or \code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}} objects using
\code{as(object, "XChromatogram")} or \code{as(object, "XChromatograms")}.
}

\section{Filtering and subsetting}{


Besides classical subsetting with \code{[} specific filter operations on
\code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}} and \code{XChromatograms} objects are available. See
\code{\link[=filterColumnsIntensityAbove]{filterColumnsIntensityAbove()}} for more details.


\itemize{
\item \code{[} allows to subset a \code{XChromatograms} object by row (\code{i}) and column
(\code{j}), with \code{i} and \code{j} being of type \code{integer}. The \code{featureDefinitions}
will also be subsetted accordingly and the \code{peakidx} column updated.
\item \code{filterMz} filters the chromatographic peaks within an \code{XChromatogram} or
\code{XChromatograms}, if a column \code{"mz"} is present in the \code{chromPeaks} matrix.
This would be the case if the \code{XChromatogram} was extracted from an
\code{\link[=XCMSnExp]{XCMSnExp()}} object with the \code{\link[=chromatogram]{chromatogram()}} function. All
chromatographic peaks with their m/z within the m/z range defined by \code{mz}
will be retained. Also feature definitions (if present) will be subset
accordingly. The function returns a filtered \code{XChromatogram} or
\code{XChromatograms} object.
\item \code{filterRt} filters chromatogram(s) by the provided retention time range.
All eventually present chromatographic peaks with their apex within the
retention time range specified with \code{rt} will be retained. Also feature
definitions, if present, will be filtered accordingly. The function
returns a filtered \code{XChromatogram} or \code{XChromatograms} object.
}
}

\section{Accessing data}{


See also help of \code{\link[MSnbase:Chromatogram-class]{MSnbase::Chromatogram()}} in the \emph{MSnbase} package for
general information and data access. The methods listed here are specific for
\code{XChromatogram} and \code{XChromatograms} objects.
\itemize{
\item \code{chromPeaks}, \verb{chromPeaks<-}: extract or set the matrix with the
chromatographic peak definitions. Parameter \code{rt} allows to specify a
retention time range for which peaks should be returned along with
parameter \code{type} that defines how \emph{overlapping} is defined (parameter
description for details). For \code{XChromatogram} objects the function returns
a \code{matrix} with columns \code{"mz"} (mean m/z value), \code{"mzmin"} (minimal m/z
value) and \code{"mzmax"} (maximal m/z value), \code{"rt"} (retention time of the
peak apex), \code{"rtmin"} (the lower peak boundary in retention time
dimension), \code{"rtmax"} (the upper peak boundary in retention time
dimension), \code{"into"} (the integrated peak signal/area of the peak),
\code{"maxo"} (the maximum instensity of the peak and \code{"sn"} (the signal to
noise ratio).
Note that, depending on the peak detection algorithm, the matrix may
contain additional columns.
For \code{XChromatograms} objects the \code{matrix} contains also columns \code{"row"}
and \code{"column"} specifying in which chromatogram of \code{object} the peak was
identified. Chromatographic peaks are ordered by row.
\item \code{chromPeakData}, \verb{chromPeakData<-}: extract or set the
\code{\link[S4Vectors:DataFrame-class]{S4Vectors::DataFrame()}} with optional chromatographic peak annotations.
\item \code{hasChromPeaks}: infer whether a \code{XChromatogram} (or \code{XChromatograms})
has chromatographic peaks. For \code{XChromatogram}: returns a \code{logical(1)},
for \code{XChromatograms}: returns a \code{matrix}, same dimensions than \code{object}
with either \code{TRUE} or \code{FALSE} if chromatographic peaks are available in
the chromatogram at the respective position.
\item \code{hasFilledChromPeaks}: whether a \code{XChromatogram} (or a \code{XChromatogram} in
a \code{XChromatograms}) has filled-in chromatographic peaks.
For \code{XChromatogram}: returns a \code{logical(1)},
for \code{XChromatograms}: returns a \code{matrix}, same dimensions than \code{object}
with either \code{TRUE} or \code{FALSE} if chromatographic peaks are available in
the chromatogram at the respective position.
\item \code{dropFilledChromPeaks}: removes filled-in chromatographic peaks. See
\code{\link[=dropFilledChromPeaks]{dropFilledChromPeaks()}} help for \code{\link[=XCMSnExp]{XCMSnExp()}} objects for more
information.
\item \code{hasFeatures}: for \code{XChromatograms} objects only: if correspondence
analysis has been performed and m/z-rt feature definitions are present.
Returns a \code{logical(1)}.
\item \code{dropFeatureDefinitions}: for \code{XChrmomatograms} objects only: delete any
correspondence analysis results (and related process history).
\item \code{featureDefinitions}: for \code{XChromatograms} objects only. Extract the
results from the correspondence analysis (performed with
\code{groupChromPeaks}). Returns a \code{DataFrame} with the properties of the
defined m/z-rt features: their m/z and retention time range. Column
\code{peakidx} contains the index of the chromatographic peaks in the
\code{chromPeaks} matrix associated with the feature. Column \code{"row"} contains
the row in the \code{XChromatograms} object in which the feature was defined.
Similar to the \code{chromPeaks} method it is possible to filter the returned
feature matrix with the \code{mz}, \code{rt} and \code{ppm} parameters.
\item \code{featureValues}: for \code{XChromatograms} objects only. Extract the abundance
estimates for the individuals features. Note that by default (with
parameter \code{value = "index"} a \code{matrix} of indices of the peaks in the
\code{chromPeaks} matrix associated to the feature is returned. To extract the
integrated peak area use \code{value = "into"}. The function returns a \code{matrix}
with one row per feature (in \code{featureDefinitions}) and each column being
a sample (i.e. column of \code{object}). For features without a peak associated
in a certain sample \code{NA} is returned. This can be changed with the
\code{missing} argument of the function.
\item \code{filterChromPeaks}: \emph{filters} chromatographic peaks in \code{object} depending
on parameter \code{method} and method-specific parameters passed as additional
arguments with \code{...}. Available methods are:
\itemize{
\item \code{method = "keepTop"}: keep top \code{n} (default \code{n = 1L}) peaks in each
chromatogram ordered by column \code{order} (defaults to \code{order = "maxo"}).
Parameter \code{decreasing} (default \code{decreasing = TRUE}) can be used to
order peaks in descending (\code{decreasing = TRUE}) or ascending (
\code{decreasing = FALSE}) order to keep the top \code{n} peaks with largest or
smallest values, respectively.
}
\item \code{processHistory}: returns a \code{list} of \link{ProcessHistory} objects representing
the individual performed processing steps. Optional parameters \code{type} and
\code{fileIndex} allow to further specify which processing steps to return.
}
}

\section{Manipulating data}{

\itemize{
\item \code{transformIntensity}: transforms the intensity values of the chromatograms
with provided function \code{FUN}. See \code{\link[MSnbase:Chromatogram-class]{MSnbase::transformIntensity()}} in the
\emph{MSnbase} package for details. For \code{XChromatogram} and \code{XChromatograms}
in addition to the intensity values also columns \code{"into"} and \code{"maxo"}
in the object's \code{chromPeaks} matrix are transformed by the same function.
}
}

\section{Plotting and visualizing}{

\itemize{
\item \code{plot} draws the chromatogram and highlights in addition any
chromatographic peaks present in the \code{XChromatogram} or \code{XChromatograms}
(unless \code{peakType = "none"} was specified). To draw peaks in different
colors a vector of color definitions with length equal to
\code{nrow(chromPeaks(x))} has to be submitted  with \code{peakCol} and/or \code{peakBg}
defining one color for each peak (in the order as peaks are in
\verb{chromPeaks(x))}. For base peak chromatograms or total ion chromatograms
it might be better to set \code{peakType = "none"} to avoid generating busy
plots.
\item \code{plotChromPeakDensity}: visualize \emph{peak density}-based correspondence
analysis results. See section \emph{Correspondence analysis} for more details.
}
}

\section{Chromatographic peak detection}{


See \link{findChromPeaks-Chromatogram-CentWaveParam} for information.

After chromatographic peak detection it is also possible to \emph{refine}
identified chromatographic peaks with the \code{refineChromPeaks} method (e.g. to
reduce peak detection artifacts). Currently, only peak refinement using the
\emph{merge neighboring peaks} method is available (see
\code{\link[=MergeNeighboringPeaksParam]{MergeNeighboringPeaksParam()}} for a detailed description of the approach.
}

\section{Correspondence analysis}{


Identified chromatographic peaks in an \code{XChromatograms} object can be grouped
into \emph{features} with the \code{groupChromPeaks} function. Currently, such a
correspondence analysis can be performed with the \emph{peak density} method
(see \link{groupChromPeaks} for more details) specifying the algorithm settings
with a \code{\link[=PeakDensityParam]{PeakDensityParam()}} object. A correspondence analysis is performed
separately for each row in the \code{XChromatograms} object grouping
chromatographic peaks across samples (columns).

The analysis results are stored in the returned \code{XChromatograms} object
and can be accessed with the \code{featureDefinitions} method which returns a
\code{DataFrame} with one row for each feature. Column \code{"row"} specifies in
which row of the \code{XChromatograms} object the feature was identified.

The \code{plotChromPeakDensity} method can be used to visualize \emph{peak density}
correspondence results, or to \emph{simulate} a peak density correspondence
analysis on chromatographic data. The resulting plot consists of two panels,
the upper panel showing the chromatographic data as well as the identified
chromatographic peaks, the lower panel the distribution of peaks (the peak
density) along the retention time axis. This plot shows each peak as a point
with it's peak's retention time on the x-axis, and the sample in which it
was found on the y-axis. The distribution of peaks along the retention time
axis is visualized with a density estimate. Grouped chromatographic peaks
are indicated with grey shaded rectangles. Parameter \code{simulate} allows to
define whether the correspondence analysis should be simulated (
\code{simulate=TRUE}, based on the available data and the provided
\code{\link[=PeakDensityParam]{PeakDensityParam()}} parameter class) or not (\code{simulate=FALSE}). For the
latter it is assumed that a correspondence analysis has been performed with
the \emph{peak density} method on the \code{object}.
See examples below.

Abundance estimates for each feature can be extracted with the
\code{featureValues} function using parameter \code{value = "into"} to extract the
integrated peak area for each feature. The result is a \code{matrix}, columns
being samples and rows features.
}

\examples{

## ---- Creation of XChromatograms ----
##
## Create a XChromatograms from Chromatogram objects
library(MSnbase)
dta <- list(Chromatogram(rtime = 1:7, c(3, 4, 6, 12, 8, 3, 2)),
    Chromatogram(1:10, c(4, 6, 3, 4, 7, 13, 43, 34, 23, 9)))

## Create an XChromatograms without peak data
xchrs <- XChromatograms(dta)

## Create an XChromatograms with peaks data
pks <- list(matrix(c(4, 2, 5, 30, 12, NA), nrow = 1,
    dimnames = list(NULL, c("rt", "rtmin", "rtmax", "into", "maxo", "sn"))),
    NULL)
xchrs <- XChromatograms(dta, chromPeaks = pks)

## Create an XChromatograms from XChromatogram objects
dta <- lapply(dta, as, "XChromatogram")
chromPeaks(dta[[1]]) <- pks[[1]]

xchrs <- XChromatograms(dta, nrow = 1)

hasChromPeaks(xchrs)

## Loading a test data set with identified chromatographic peaks
faahko_sub <- loadXcmsData("faahko_sub2")

## Subset the dataset to the first and third file.
xod_sub <- filterFile(faahko_sub, file = c(1, 3))

od <- as(xod_sub, "MsExperiment")

## Extract chromatograms for a m/z - retention time slice
chrs <- chromatogram(od, mz = 344, rt = c(2500, 3500))
chrs

## --------------------------------------------------- ##
##       Chromatographic peak detection                ##
## --------------------------------------------------- ##
## Perform peak detection using CentWave
xchrs <- findChromPeaks(chrs, param = CentWaveParam())
xchrs

## Do we have chromatographic peaks?
hasChromPeaks(xchrs)

## Process history
processHistory(xchrs)

## The chromatographic peaks, columns "row" and "column" provide information
## in which sample the peak was identified.
chromPeaks(xchrs)

## Spectifically extract chromatographic peaks for one sample/chromatogram
chromPeaks(xchrs[1, 2])

## Plot the results
plot(xchrs)

## Plot the results using a different color for each sample
sample_colors <- c("#ff000040", "#00ff0040", "#0000ff40")
cols <- sample_colors[chromPeaks(xchrs)[, "column"]]
plot(xchrs, col = sample_colors, peakBg = cols)

## Indicate the peaks with a rectangle
plot(xchrs, col = sample_colors, peakCol = cols, peakType = "rectangle",
    peakBg = NA)

## --------------------------------------------------- ##
##       Correspondence analysis                       ##
## --------------------------------------------------- ##
## Group chromatographic peaks across samples
prm <- PeakDensityParam(sampleGroup = rep(1, 2))
res <- groupChromPeaks(xchrs, param = prm)

hasFeatures(res)
featureDefinitions(res)

## Plot the correspondence results. Use simulate = FALSE to show the
## actual results. Grouped chromatographic peaks are indicated with
## grey shaded rectangles.
plotChromPeakDensity(res, simulate = FALSE)

## Simulate a correspondence analysis based on different settings. Larger
## bw will increase the smoothing of the density estimate hence grouping
## chromatographic peaks that are more apart on the retention time axis.
prm <- PeakDensityParam(sampleGroup = rep(1, 3), bw = 60)
plotChromPeakDensity(res, param = prm)

## Delete the identified feature definitions
res <- dropFeatureDefinitions(res)
hasFeatures(res)

library(MSnbase)
## Create a XChromatogram object
pks <- matrix(nrow = 1, ncol = 6)
colnames(pks) <- c("rt", "rtmin", "rtmax", "into", "maxo", "sn")
pks[, "rtmin"] <- 2
pks[, "rtmax"] <- 9
pks[, "rt"] <- 4
pks[, "maxo"] <- 19
pks[, "into"] <- 93

xchr <- XChromatogram(rtime = 1:10,
    intensity = c(4, 8, 14, 19, 18, 12, 9, 8, 5, 2),
    chromPeaks = pks)
xchr

## Add arbitrary peak annotations
df <- DataFrame(peak_id = c("a"))
xchr <- XChromatogram(rtime = 1:10,
    intensity = c(4, 8, 14, 19, 18, 12, 9, 8, 5, 2),
    chromPeaks = pks, chromPeakData = df)
xchr
chromPeakData(xchr)

## Extract the chromatographic peaks
chromPeaks(xchr)

## Plotting of a single XChromatogram object
## o Don't highlight chromatographic peaks
plot(xchr, peakType = "none")

## o Indicate peaks with a polygon
plot(xchr)

## Add a second peak to the data.
pks <- rbind(chromPeaks(xchr), c(7, 7, 10, NA, 15, NA))
chromPeaks(xchr) <- pks

## Plot the peaks in different colors
plot(xchr, peakCol = c("#ff000080", "#0000ff80"),
    peakBg = c("#ff000020", "#0000ff20"))

## Indicate the peaks as rectangles
plot(xchr, peakCol = c("#ff000060", "#0000ff60"), peakBg = NA,
    peakType = "rectangle")

## Filter the XChromatogram by retention time
xchr_sub <- filterRt(xchr, rt = c(4, 6))
xchr_sub
plot(xchr_sub)
}
\seealso{
\link[=findChromPeaks-Chromatogram-CentWaveParam]{findChromPeaks-centWave} for peak
detection on \code{\link[MSnbase:MChromatograms-class]{MSnbase::MChromatograms()}} objects.
}
\author{
Johannes Rainer
}
