% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_findChromPeaks-functions.R
\name{do_findChromPeaks_centWaveWithPredIsoROIs}
\alias{do_findChromPeaks_centWaveWithPredIsoROIs}
\alias{do_findChromPeaks_addPredIsoROIs}
\title{Core API function for two-step centWave peak detection with isotopes}
\usage{
do_findChromPeaks_centWaveWithPredIsoROIs(
  mz,
  int,
  scantime,
  valsPerSpect,
  ppm = 25,
  peakwidth = c(20, 50),
  snthresh = 10,
  prefilter = c(3, 100),
  mzCenterFun = "wMean",
  integrate = 1,
  mzdiff = -0.001,
  fitgauss = FALSE,
  noise = 0,
  verboseColumns = FALSE,
  roiList = list(),
  firstBaselineCheck = TRUE,
  roiScales = NULL,
  snthreshIsoROIs = 6.25,
  maxCharge = 3,
  maxIso = 5,
  mzIntervalExtension = TRUE,
  polarity = "unknown",
  extendLengthMSW = FALSE,
  verboseBetaColumns = FALSE
)

do_findChromPeaks_addPredIsoROIs(
  mz,
  int,
  scantime,
  valsPerSpect,
  ppm = 25,
  peakwidth = c(20, 50),
  snthresh = 6.25,
  prefilter = c(3, 100),
  mzCenterFun = "wMean",
  integrate = 1,
  mzdiff = -0.001,
  fitgauss = FALSE,
  noise = 0,
  verboseColumns = FALSE,
  peaks. = NULL,
  maxCharge = 3,
  maxIso = 5,
  mzIntervalExtension = TRUE,
  polarity = "unknown"
)
}
\arguments{
\item{mz}{Numeric vector with the individual m/z values from all scans/
spectra of one file/sample.}

\item{int}{Numeric vector with the individual intensity values from all
scans/spectra of one file/sample.}

\item{scantime}{Numeric vector of length equal to the number of
spectra/scans of the data representing the retention time of each scan.}

\item{valsPerSpect}{Numeric vector with the number of values for each
spectrum.}

\item{ppm}{\code{numeric(1)} defining the maximal tolerated m/z deviation in
consecutive scans in parts per million (ppm) for the initial ROI
definition.}

\item{peakwidth}{\code{numeric(2)} with the expected approximate
peak width in chromatographic space. Given as a range (min, max)
in seconds.}

\item{snthresh}{For \code{do_findChromPeaks_addPredIsoROIs}:
\code{numeric(1)} defining the signal to noise threshold for the centWave
algorithm. For \code{do_findChromPeaks_centWaveWithPredIsoROIs}:
\code{numeric(1)} defining the signal to noise threshold for the initial
(first) centWave run.}

\item{prefilter}{\code{numeric(2)}: \code{c(k, I)} specifying the prefilter
step for the first analysis step (ROI detection). Mass traces are only
retained if they contain at least \code{k} peaks with intensity
\verb{>= I}.}

\item{mzCenterFun}{Name of the function to calculate the m/z center of the
chromatographic peak. Allowed are: \code{"wMean"}: intensity weighted
mean of the peak's m/z values, \code{"mean"}: mean of the peak's m/z
values, \code{"apex"}: use the m/z value at the peak apex,
\code{"wMeanApex3"}: intensity weighted mean of the m/z value at the
peak apex and the m/z values left and right of it and \code{"meanApex3"}:
mean of the m/z value of the peak apex and the m/z values left and right
of it.}

\item{integrate}{Integration method. For \code{integrate = 1} peak limits
are found through descent on the mexican hat filtered data, for
\code{integrate = 2} the descent is done on the real data. The latter
method is more accurate but prone to noise, while the former is more
robust, but less exact.}

\item{mzdiff}{\code{numeric(1)} representing the minimum difference in m/z
dimension required for peaks with overlapping retention times; can be
negative to allow overlap. During peak post-processing, peaks
defined to be overlapping are reduced to the one peak with the largest
signal.}

\item{fitgauss}{\code{logical(1)} whether or not a Gaussian should be fitted
to each peak. This affects mostly the retention time position of the
peak.}

\item{noise}{\code{numeric(1)} allowing to set a minimum intensity required
for centroids to be considered in the first analysis step (centroids with
intensity \verb{< noise} are omitted from ROI detection).}

\item{verboseColumns}{\code{logical(1)} whether additional peak meta data
columns should be returned.}

\item{roiList}{An optional list of regions-of-interest (ROI) representing
detected mass traces. If ROIs are submitted the first analysis step is
omitted and chromatographic peak detection is performed on the submitted
ROIs. Each ROI is expected to have the following elements specified:
\code{scmin} (start scan index), \code{scmax} (end scan index),
\code{mzmin} (minimum m/z), \code{mzmax} (maximum m/z), \code{length}
(number of scans), \code{intensity} (summed intensity). Each ROI should
be represented by a \code{list} of elements or a single row
\code{data.frame}.}

\item{firstBaselineCheck}{\code{logical(1)}. If \code{TRUE} continuous
data within regions of interest is checked to be above the first baseline.
In detail, a first rough estimate of the noise is calculated and peak
detection is performed only in regions in which multiple sequential
signals are higher than this first estimated baseline/noise level.}

\item{roiScales}{Optional numeric vector with length equal to \code{roiList}
defining the scale for each region of interest in \code{roiList} that
should be used for the centWave-wavelets.}

\item{snthreshIsoROIs}{\code{numeric(1)} defining the signal to noise ratio
cutoff to be used in the second centWave run to identify peaks for
predicted isotope ROIs.}

\item{maxCharge}{\code{integer(1)} defining the maximal isotope charge.
Isotopes will be defined for charges \code{1:maxCharge}.}

\item{maxIso}{\code{integer(1)} defining the number of isotope peaks that
should be predicted for each peak identified in the first centWave run.}

\item{mzIntervalExtension}{\code{logical(1)} whether the mz range for the
predicted isotope ROIs should be extended to increase detection of low
intensity peaks.}

\item{polarity}{\code{character(1)} specifying the polarity of the data.
Currently not used, but has to be \code{"positive"}, \code{"negative"} or
\code{"unknown"} if provided.}

\item{extendLengthMSW}{Option to force centWave to use all scales when
running centWave rather than truncating with the EIC length. Uses the
"open" method to extend the EIC to a integer base-2 length prior to
being passed to \code{convolve} rather than the default "reflect" method. See
https://github.com/sneumann/xcms/issues/445 for more information.}

\item{verboseBetaColumns}{Option to calculate two additional metrics of peak
quality via comparison to an idealized bell curve. Adds \code{beta_cor} and
\code{beta_snr} to the \code{chromPeaks} output, corresponding to a Pearson
correlation coefficient to a bell curve with several degrees of skew
as well as an estimate of signal-to-noise using the residuals from the
best-fitting bell curve. See https://github.com/sneumann/xcms/pull/685
and https://doi.org/10.1186/s12859-023-05533-4 for more information.}

\item{peaks.}{A matrix such as one returned by
a call to \code{\link[=do_findChromPeaks_centWave]{do_findChromPeaks_centWave()}} (with \code{verboseColumns = TRUE})
with the peaks for which isotopes should be predicted and used for an
additional peak detectoin using the centWave method. Required columns
are: \code{"mz"}, \code{"mzmin"}, \code{"mzmax"}, \code{"scmin"},
\code{"scmax"}, \code{"scale"} and \code{"into"}.}
}
\value{
A matrix, each row representing an identified chromatographic peak.
All non-overlapping peaks identified in both centWave runs are reported.
The matrix columns are:
\itemize{
\item \code{"mz"}: Intensity weighted mean of m/z values of the peaks across scans.
\item \code{"mzmin"}: Minimum m/z of the peaks.
\item \code{"mzmax"}: Maximum m/z of the peaks.
\item \code{"rt"}: Retention time of the peak's midpoint.
\item \code{"rtmin"}: Minimum retention time of the peak.
\item \code{"rtmax"}: Maximum retention time of the peak.
\item \code{"into"}: Integrated (original) intensity of the peak.
\item \code{"intb"}: Per-peak baseline corrected integrated peak intensity.
\item \code{"maxo"}: Maximum intensity of the peak.
\item \code{"sn"}: Signal to noise ratio, defined as \code{(maxo - baseline)/sd},
\code{sd} being the standard deviation of local chromatographic noise.
\item \code{"egauss"}: RMSE of Gaussian fit.
}

Additional columns for \code{verboseColumns = TRUE}:
\itemize{
\item \code{"mu"}: Gaussian parameter mu.
\item \code{"sigma"}: Gaussian parameter sigma.
\item \code{"h"}: Gaussian parameter h.
\item \code{"f"}: Region number of the m/z ROI where the peak was localized.
\item \code{"dppm"}: m/z deviation of mass trace across scans in ppm.
\item \code{"scale"}: Scale on which the peak was localized.
\item \code{"scpos"}: Peak position found by wavelet analysis (scan number).
\item \code{"scmin"}: Left peak limit found by wavelet analysis (scan number).
\item \code{"scmax"}: Right peak limit found by wavelet analysis (scan numer).
}

Additional columns for \code{verboseBetaColumns = TRUE}:
\itemize{
\item \code{"beta_cor"}: Correlation between an "ideal" bell curve and the raw data.
\item \code{"beta_snr"}: Signal-to-noise residuals calculated from the beta_cor fit.
}
}
\description{
The \code{do_findChromPeaks_centWaveWithPredIsoROIs} performs a
two-step centWave based peak detection: chromatographic peaks are
identified using centWave followed by a prediction of the location of
the identified peaks' isotopes in the mz-retention time space. These
locations are fed as \emph{regions of interest} (ROIs) to a subsequent
centWave run. All non overlapping peaks from these two peak detection
runs are reported as the final list of identified peaks.

The \code{do_findChromPeaks_centWaveAddPredIsoROIs} performs
centWave based peak detection based in regions of interest (ROIs)
representing predicted isotopes for the peaks submitted with argument
\code{peaks}. The function returns a matrix with the identified peaks
consisting of all input peaks and peaks representing predicted isotopes
of these (if found by the centWave algorithm).
}
\details{
For more details on the centWave algorithm see
\code{\link[=centWave]{centWave()}}.
}
\seealso{
Other core peak detection functions: 
\code{\link{do_findChromPeaks_centWave}()},
\code{\link{do_findChromPeaks_massifquant}()},
\code{\link{do_findChromPeaks_matchedFilter}()},
\code{\link{do_findPeaks_MSW}()}
}
\author{
Hendrik Treutler, Johannes Rainer
}
\concept{core peak detection functions}
