% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{modelGeneExpression_significance_testing_wraper}
\alias{modelGeneExpression_significance_testing_wraper}
\title{Statistical testing of ridge regression estimates wrapper for modelGeneExpression}
\usage{
modelGeneExpression_significance_testing_wraper(
  mae,
  yname,
  uname,
  xnames,
  groups,
  standardize,
  regression_models
)
}
\arguments{
\item{mae}{MultiAssayExperiment object such as produced by
\code{\link{prepareCountsForRegression}}.}

\item{yname}{string indicating experiment in \code{mae} to use as the
expression input.}

\item{uname}{string indicating experiment in \code{mae} to use as the basal
expression level.}

\item{xnames}{character indicating experiments in \code{mae} to use as
molecular signatures.}

\item{groups}{factor representation of design matrix.}

\item{standardize}{logical flag indicating if the molecular signatures should
be scaled. Advised to be set to \code{TRUE}.}

\item{regression_models}{Named list with elements corresponding to signatures
specified in \code{xnames}. Each of these is a list holding
\code{'cv.glmnet'} objects corresponding to each sample. Usually returned
by \code{modelGeneExpression_ridge_regression_wraper}.}
}
\value{
Named list with elements corresponding to signatures specified in
\code{xnames}. Each of these is a list holding \code{data.frame} of
signature's p-values and test statistics estimated for each sample.
}
\description{
Internal function used in \code{modelGeneExpression}. It runs \code{ridgePvals}
parallelly across signatures and samples as specified by experiment design.
}
