% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/filterGenes.R
\name{filterGenes}
\alias{filterGenes}
\title{Filter specific genes}
\usage{
filterGenes(obj, labels = c("X", "Y", "MT"),
  featureName = "chromosome_name", keepOnly = FALSE)
}
\arguments{
\item{obj}{ExpressionSet object.}

\item{labels}{Labels of genes to filter or keep, eg. X, Y, and MT}

\item{featureName}{FeatureData column name, eg. chr}

\item{keepOnly}{Filter or keep only the genes with those labels}
}
\value{
Filtered ExpressionSet object
}
\description{
The main use case for this function is the removal of sex-chromosome genes.
Alternatively, filter genes that are not protein-coding.
}
\examples{
data(skin)
filterGenes(skin,labels = c('X','Y','MT'),featureName='chromosome_name')
filterGenes(skin,labels = 'protein_coding',featureName='gene_biotype',keepOnly=TRUE)

}
