% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_GeneOntology.R
\name{get_GeneOntology}
\alias{get_GeneOntology}
\title{Load Gene Ontology genesets}
\usage{
get_GeneOntology(
  onto = c("BP", "MF", "CC"),
  to = "ENSEMBL",
  includeOffspring = TRUE,
  org = "hsa"
)
}
\arguments{
\item{onto}{array of categories to load}

\item{to}{convert gene names to this type using \code{EnrichmentBrowser::idMap()}.  See \code{EnrichmentBrowser::idTypes(org="hsa")} for valid types}

\item{includeOffspring}{if TRUE, follow the GO hierarchy down and include all genes in offspring sets for a given gene set}

\item{org}{organism.  human (\code{'hsa'}), mouse (\code{'mmu'}), etc}
}
\value{
Gene sets stored as GeneSetCollection
}
\description{
Load Gene Ontology genesets
}
\details{
This function loads the GO gene sets using the packages \code{EnrichmentBrowser} and \code{GO.db}  It can take a mintute to load because converting gene name type is slow.
}
\examples{
# load GO Biological Process
# gs = get_GeneOntology('BP')

# load all gene sets
# gs = get_GeneOntology()

}
