% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotZenithResults.R
\name{plotZenithResults}
\alias{plotZenithResults}
\title{Heatmap of zenith results using ggplot2}
\usage{
plotZenithResults(
  df,
  ntop = 5,
  nbottom = 5,
  label.angle = 45,
  zmax = NULL,
  transpose = FALSE,
  sortByGeneset = TRUE
)
}
\arguments{
\item{df}{result \code{data.frame} from \link{zenith_gsa}}

\item{ntop}{number of gene sets with highest t-statistic to show}

\item{nbottom}{number of gene sets with lowest t-statistic to show}

\item{label.angle}{angle of x-axis label}

\item{zmax}{maxium of the color scales.  If not specified, used range of the observed t-statistics}

\item{transpose}{transpose the axes of the plot}

\item{sortByGeneset}{use hierarchical clustering to sort gene sets. Default is TRUE}
}
\value{
Heatmap showing enrichment for gene sets and cell types
}
\description{
Heatmap of zenith results showing genesets that have the top and bottom t-statistics from each assay.
}
\examples{
# Load packages
library(edgeR)
library(variancePartition)
library(tweeDEseqCountData)

# Load RNA-seq data from LCL's
data(pickrell)
geneCounts = exprs(pickrell.eset)
df_metadata = pData(pickrell.eset)

# Filter genes
# Note this is low coverage data, so just use as code example
dsgn = model.matrix(~ gender, df_metadata)
keep = filterByExpr(geneCounts, dsgn, min.count=5)

# Compute library size normalization
dge = DGEList(counts = geneCounts[keep,])
dge = calcNormFactors(dge)

# Estimate precision weights using voom
vobj = voomWithDreamWeights(dge, ~ gender, df_metadata)

# Apply dream analysis
fit = dream(vobj, ~ gender,df_metadata)
fit = eBayes(fit)

# Load Hallmark genes from MSigDB
# use gene 'SYMBOL', or 'ENSEMBL' id
# use get_GeneOntology() to load Gene Ontology
gs = get_MSigDB("H", to="ENSEMBL")
   
# Run zenith analysis
res.gsa = zenith_gsa(fit, gs, 'gendermale', progressbar=FALSE )

# Show top gene sets
head(res.gsa, 2)

# for each cell type select 3 genesets with largest t-statistic
# and 1 geneset with the lowest
# Grey boxes indicate the gene set could not be evaluted because
#    to few genes were represented
plotZenithResults(res.gsa)

}
