% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{getEpsilon_alpha}
\alias{getEpsilon_alpha}
\title{Returns the vector of regularization parameter for alpha}
\usage{
getEpsilon_alpha(object)
}
\arguments{
\item{object}{an object that describes a matrix of zero-inflated
distributions.}
}
\value{
the regularization parameters for \code{alpha_mu} and
  \code{alpha_pi}.
}
\description{
Given an object describing a ZINB model, returns a vector of size the number
of rows in the parameter \code{alpha} with the regularization parameters
associated to each row. Here \code{alpha} refers to both \code{alpha_mu} and
\code{alpha_pi}, which have the same size and have the same regularization.
}
\examples{
a <- zinbModel(n=5, J=10)
getEpsilon_alpha(a)
}
