% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zinb_fit.R
\name{zinbOptimizeDispersion}
\alias{zinbOptimizeDispersion}
\title{Optimize the dispersion parameters of a ZINB regression model}
\usage{
zinbOptimizeDispersion(
  J,
  mu,
  logitPi,
  epsilon,
  Y,
  commondispersion = TRUE,
  BPPARAM = BiocParallel::bpparam()
)
}
\arguments{
\item{J}{The number of genes.}

\item{mu}{the matrix containing the mean of the negative binomial.}

\item{logitPi}{the matrix containing the logit of the probability parameter
of the zero-inflation part of the model.}

\item{epsilon}{the regularization parameter.}

\item{Y}{The matrix of counts.}

\item{commondispersion}{Whether or not a single dispersion for all features
is estimated (default TRUE)}

\item{BPPARAM}{object of class \code{bpparamClass} that specifies the
back-end to be used for computations. See
\code{\link[BiocParallel]{bpparam}} for details.}
}
\value{
An object of class ZinbModel similar to the one given as argument
  with modified parameters zeta.
}
\description{
The dispersion parameters of the model are optimized by
penalized maximum likelihood on the count matrix given as argument.
}
\examples{
Y = matrix(10, 3, 5)
m = zinbModel(n=NROW(Y), J=NCOL(Y))
m = zinbInitialize(m, Y, BPPARAM=BiocParallel::SerialParam())
m = zinbOptimizeDispersion(NROW(Y), getMu(m), getLogitPi(m),
     getEpsilon_zeta(m), Y, BPPARAM=BiocParallel::SerialParam())
}
