% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inherited_functions.R
\name{rowQuantiles}
\alias{rowQuantiles}
\alias{rowQuantiles,Zi-method}
\alias{colQuantiles}
\alias{colQuantiles,Zi-method}
\title{Calculate the row or column quantiles of zero-deinflated count data}
\usage{
\S4method{rowQuantiles}{Zi}(
  x,
  rows = NULL,
  cols = NULL,
  probs = seq(from = 0, to = 1, by = 0.25),
  na.rm = TRUE,
  type = 7L,
  ...,
  useNames = TRUE,
  drop = TRUE
)

\S4method{colQuantiles}{Zi}(
  x,
  rows = NULL,
  cols = NULL,
  probs = seq(from = 0, to = 1, by = 0.25),
  na.rm = TRUE,
  type = 7L,
  ...,
  useNames = TRUE,
  drop = TRUE
)
}
\arguments{
\item{x}{A \code{\linkS4class{Zi}}-class object}

\item{rows, cols}{A \code{\link[base]{vector}} indicating the subset of rows
and/or columns to operate over. If \code{\link{NULL}} (default), no subsetting
is done.}

\item{probs}{A numeric \code{\link[base]{vector}} of J probabilities in
[0,1]}

\item{na.rm}{\code{\link[base]{logical}} If \code{\link{TRUE}}
\code{\link{NA}}s are excluded, otherwise not. default = \code{\link{TRUE}}}

\item{type}{An integer specifying the type of estimator}

\item{...}{Additional arguments passed to specific methods
\link[MatrixGenerics]{rowQuantiles}}

\item{useNames}{\code{\link[base]{logical}}  If \code{\link{TRUE}} (default),
names attributes of result are set. Else if \code{\link{FALSE}}, no naming
support is done.}

\item{drop}{If \code{\link{TRUE}} a \code{\link[base]{vector}} is returned if
J == 1.}
}
\value{
a numeric \code{\link[base]{vector}} of row/column length
}
\description{
Calculate the row or column quantiles of  zero-deinflated data
of a \code{\linkS4class{Zi}}-class object. To calculate the quantiles, the
deinflatedcounts matrix will be extracted
}
\examples{
data(mtx)
Zi <- ziMain(mtx)
rowQuantiles(Zi, useNames = TRUE)
colQuantiles(Zi, useNames = TRUE)
}
