## ----load AnnotationHub, results='hide'---------------------------------------
library(AnnotationHub, quietly = TRUE)

## ----setup--------------------------------------------------------------------
hub <- AnnotationHub()
ah <- query(hub, "CENTREannotation")
ah

## ----CENTREannotDb------------------------------------------------------------
library(CENTREannotation)
CENTREannotgeneDb <- ah[["AH116730"]]
CENTREannotenhDb <- ah[["AH116731"]]

## ----use CENTREannotDb--------------------------------------------------------
tables(CENTREannotenhDb)
res <- fetch_data(CENTREannotenhDb,
    columns = c("enhancer_id", "start"),
    entries = c("EH38E1519134", "EH38E1519132"),
    column_filter = "enhancer_id"
)

## ----sessionInfo--------------------------------------------------------------
sessionInfo()

