% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{TENET_10_cancer_panel_enhancer_regions}
\alias{TENET_10_cancer_panel_enhancer_regions}
\title{TENET 10 cancer panel enhancer regions}
\usage{
TENET_10_cancer_panel_enhancer_regions(metadata = FALSE)
}
\arguments{
\item{metadata}{If TRUE, retrieve the AnnotationHub metadata instead of the
object itself. Defaults to FALSE.}
}
\value{
A GRanges object with 4,798,784 non-reduced ranges and metadata
consisting of 1 variable. The peaks within each cancer type are reduced, but
the final dataset with peaks across all 10 cancer types is not reduced.
\describe{
\item{\code{TYPE}}{(character) Lists which of the ten cancer types (BLCA, BRCA, COAD, ESCA, HNSC, KIRP, LIHC, LUAD, LUSC, or THCA) each region is relevant to}
}
}
\description{
A composite GRanges object containing regions of putative
enhancer elements from 10 different cancer types (BRCA, BLCA, COAD, ESCA,
HNSC, KIRP, LIHC, LUAD, LUSC, and THCA) primarily for use in the TENET
Bioconductor package. This dataset is composed of H3K27ac and H3K4me1 peaks
from ChIP-seq datasets collected from Cistrome.org and processed using the
ENCODE pipelines. For additional information on component datasets, see the
manifest file hosted at
\url{https://github.com/rhielab/TENET.AnnotationHub/blob/devel/data-raw/TENET_10_cancer_panel_enhancer_regions_manifest.tsv}.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
TENET_10_cancer_panel_enhancer_regions()
\dontshow{\}) # examplesIf}
}
