## ----eval=FALSE---------------------------------------------------------------
# # Installation
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#   install.packages("BiocManager")
# }
# BiocManager::install(version = "devel")
# if (!requireNamespace("AnnotationHub", quietly = TRUE)) {
#   install.packages("AnnotationHub")
# }

## -----------------------------------------------------------------------------
# Loading the Package
library(AnnotationHub)

## -----------------------------------------------------------------------------
# Installing the org.Hbacteriophora.eg.db package
ah <- AnnotationHub()
org.Hbacteriophora.eg.db <- ah[["AH121717"]]

## ----keytypes-----------------------------------------------------------------
# List all supported key types
keytypes(org.Hbacteriophora.eg.db)

## ----genes--------------------------------------------------------------------
# Accessing Gene Information
keys <- head(keys(org.Hbacteriophora.eg.db, 
                  keytype = "GID")) # Get sample gene IDs
select(org.Hbacteriophora.eg.db, 
       keys = keys, 
       columns = c("GENENAME", "SYMBOL"), 
       keytype = "GID")

## ----gos----------------------------------------------------------------------
# Querying GO Terms
select(org.Hbacteriophora.eg.db, 
       keys = keys, 
       columns = c("GO", "ONTOLOGY"), 
       keytype = "GID")

## ----go_terms-----------------------------------------------------------------
# Extracting GO terms for Biological Process
select(org.Hbacteriophora.eg.db, 
       keys = keys, 
       columns = c("GO", "ONTOLOGY"), 
       keytype = "GID") %>%
  dplyr::filter(ONTOLOGY == "BP")

## ----kegg---------------------------------------------------------------------
# Querying KEGG Pathway Information
select(org.Hbacteriophora.eg.db, 
       keys = keys, 
       columns = "KEGGPATHWAY", 
       keytype = "GID")

## ----session------------------------------------------------------------------
sessionInfo()

